/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateProcedureUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateProcedureAction
extends CayenneAction {
    public CreateProcedureAction(Application application) {
        super(CreateProcedureAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Create Stored Procedure";
    }

    static void fireProcedureEvent(Object src, ProjectController mediator, DataMap dataMap, Procedure procedure) {
        mediator.fireProcedureEvent(new ProcedureEvent(src, procedure, 2));
        mediator.fireProcedureDisplayEvent(new ProcedureDisplayEvent(src, procedure, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode()));
    }

    @Override
    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        DataMap map = mediator.getCurrentDataMap();
        Procedure procedure = new Procedure();
        procedure.setName(NameBuilder.builder(procedure, map).name());
        this.createProcedure(map, procedure);
        this.application.getUndoManager().addEdit(new CreateProcedureUndoableEdit(map, procedure));
    }

    public void createProcedure(DataMap map, Procedure procedure) {
        ProjectController mediator = this.getProjectController();
        procedure.setSchema(map.getDefaultSchema());
        procedure.setCatalog(map.getDefaultCatalog());
        map.addProcedure(procedure);
        CreateProcedureAction.fireProcedureEvent(this, mediator, map, procedure);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return ((Procedure)object).getDataMap() != null;
    }

    @Override
    public String getIconName() {
        return "icon-stored-procedure.png";
    }
}

