/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.CursorTableReference;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public class CursorNode
extends DMLStatementNode {
    static final int UNSPECIFIED = 0;
    public static final int READ_ONLY = 1;
    static final int UPDATE = 2;
    private String name;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    private String statementType;
    private int updateMode;
    private boolean needTarget;
    private List<String> updatableColumns;
    private FromTable updateTable;
    private ArrayList<TableDescriptor> statsToUpdate;
    private boolean checkIndexStats;
    private int indexOfSessionTableNamesInSavedObjects = -1;
    private boolean forMergeStatement;

    CursorNode(String statementType, ResultSetNode resultSet, String name, OrderByList orderByList, ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause, int updateMode, String[] updatableColumns, boolean forMergeStatement, ContextManager cm) {
        super(resultSet, cm);
        this.name = name;
        this.statementType = statementType;
        this.orderByList = orderByList;
        this.offset = offset;
        this.fetchFirst = fetchFirst;
        this.hasJDBClimitClause = hasJDBClimitClause;
        this.updateMode = updateMode;
        this.updatableColumns = updatableColumns == null ? null : Arrays.asList(updatableColumns);
        this.forMergeStatement = forMergeStatement;
        SanityManager.ASSERT(this.updatableColumns == null || this.updatableColumns.isEmpty() || this.updateMode == 2, "Can only have explicit updatable columns if update mode is UPDATE");
    }

    @Override
    public String toString() {
        return "name: " + this.name + "\nupdateMode: " + CursorNode.updateModeString(this.updateMode) + "\n" + super.toString();
    }

    @Override
    String statementToString() {
        return this.statementType;
    }

    private static String updateModeString(int updateMode) {
        switch (updateMode) {
            case 0: {
                return "UNSPECIFIED (0)";
            }
            case 1: {
                return "READ_ONLY (1)";
            }
            case 2: {
                return "UPDATE (2)";
            }
        }
        return "UNKNOWN VALUE (" + updateMode + ")";
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: " + depth);
            this.orderByList.treePrint(depth + 1);
        }
        if (this.offset != null) {
            this.printLabel(depth, "offset:");
            this.offset.treePrint(depth + 1);
        }
        if (this.fetchFirst != null) {
            this.printLabel(depth, "fetch first/next:");
            this.fetchFirst.treePrint(depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        ArrayList<String> sessionSchemaTableNames;
        boolean wasSkippingTypePrivileges = this.getCompilerContext().skipTypePrivileges(true);
        DataDictionary dataDictionary = this.getDataDictionary();
        boolean bl = this.checkIndexStats = dataDictionary.getIndexStatsRefresher(true) != null;
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
        }
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            this.resultSet.rejectParameters();
            super.bind(dataDictionary);
            this.resultSet.bindResultColumns(fromList);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            if (!this.forMergeStatement) {
                this.resultSet.rejectXMLValues();
            }
            SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        this.collectTablesWithPossiblyStaleStats();
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        CursorNode.bindOffsetFetch(this.offset, this.fetchFirst);
        if (this.updateMode == 2) {
            int checkedUpdateMode = this.determineUpdateMode(dataDictionary);
            SanityManager.DEBUG("DumpUpdateCheck", "update mode is UPDATE (" + this.updateMode + ") checked mode is " + checkedUpdateMode);
            if (this.updateMode != checkedUpdateMode) {
                throw StandardException.newException("42Y90", new Object[0]);
            }
        }
        if (this.updateMode == 0) {
            this.updateMode = this.getLanguageConnectionContext().getStatementContext().isForReadOnly() ? 1 : this.determineUpdateMode(dataDictionary);
        }
        if (this.updateMode == 1) {
            this.updatableColumns = null;
        }
        if (this.updateMode == 2) {
            this.bindUpdateColumns(this.updateTable);
            if (this.updateTable != null) {
                this.updateTable.markUpdatableByCursor(this.updatableColumns);
                this.resultSet.getResultColumns().markColumnsInSelectListUpdatableByCursor(this.updatableColumns);
            }
        }
        this.resultSet.renameGeneratedResultNames();
        if (this.getLanguageConnectionContext().checkIfAnyDeclaredGlobalTempTablesForThisConnection() && (sessionSchemaTableNames = this.getSessionSchemaTableNamesForCursor()) != null) {
            this.indexOfSessionTableNamesInSavedObjects = this.getCompilerContext().addSavedObject(sessionSchemaTableNames);
        }
        this.getCompilerContext().skipTypePrivileges(wasSkippingTypePrivileges);
    }

    private void collectTablesWithPossiblyStaleStats() throws StandardException {
        if (!this.checkIndexStats) {
            return;
        }
        FromList fromList = this.resultSet.getFromList();
        for (int i = 0; i < fromList.size(); ++i) {
            TableDescriptor td;
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (!fromTable.isBaseTable() || (td = fromTable.getTableDescriptor()).getTableType() != 0) continue;
            if (this.statsToUpdate == null) {
                this.statsToUpdate = new ArrayList();
            }
            this.statsToUpdate.add(td);
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    protected ArrayList<String> getSessionSchemaTableNamesForCursor() throws StandardException {
        FromList fromList = this.resultSet.getFromList();
        int fromListSize = fromList.size();
        ArrayList<String> sessionSchemaTableNames = null;
        for (int i = 0; i < fromListSize; ++i) {
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (!(fromTable instanceof FromBaseTable) || !this.isSessionSchema(fromTable.getTableDescriptor().getSchemaDescriptor())) continue;
            if (sessionSchemaTableNames == null) {
                sessionSchemaTableNames = new ArrayList<String>();
            }
            sessionSchemaTableNames.add(fromTable.getTableName().getTableName());
        }
        return sessionSchemaTableNames;
    }

    private int determineUpdateMode(DataDictionary dataDictionary) throws StandardException {
        if (this.updateMode == 1) {
            return 1;
        }
        if (this.orderByList != null) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor has order by");
            return 1;
        }
        if (!this.resultSet.isUpdatableCursor(dataDictionary)) {
            return 1;
        }
        this.updateTable = this.resultSet.getCursorTargetTable();
        if (this.updateTable.markAsCursorTargetTable()) {
            this.needTarget = true;
        }
        return 2;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        this.resultSet.pushQueryExpressionSuffix();
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.resultSet.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        this.offset = null;
        this.fetchFirst = null;
        super.optimizeStatement();
    }

    @Override
    int activationKind() {
        return 4;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.indexOfSessionTableNamesInSavedObjects != -1) {
            MethodBuilder constructor = acb.getConstructor();
            constructor.pushThis();
            constructor.push(this.indexOfSessionTableNamesInSavedObjects);
            constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "indexOfSessionTableNamesInSavedObjects", "int");
            constructor.endStatement();
        }
        this.generateParameterValueSet(acb);
        this.resultSet.markStatementResultSet();
        this.resultSet.generate(acb, mb);
        if (this.needTarget) {
            acb.rememberCursor(mb);
            acb.addCursorPositionCode();
        }
    }

    String getUpdateBaseTableName() {
        return this.updateTable == null ? null : this.updateTable.getBaseTableName();
    }

    String getUpdateExposedTableName() throws StandardException {
        return this.updateTable == null ? null : this.updateTable.getExposedName();
    }

    String getUpdateSchemaName() throws StandardException {
        return this.updateTable == null ? null : ((FromBaseTable)this.updateTable).getTableNameField().getSchemaName();
    }

    int getUpdateMode() {
        return this.updateMode;
    }

    @Override
    public boolean needsSavepoint() {
        return false;
    }

    @Override
    public Object getCursorInfo() throws StandardException {
        if (!this.needTarget) {
            return null;
        }
        return new CursorInfo(this.updateMode, new CursorTableReference(this.getUpdateExposedTableName(), this.getUpdateBaseTableName(), this.getUpdateSchemaName()), this.updatableColumns);
    }

    private void bindUpdateColumns(FromTable targetTable) throws StandardException {
        int size = this.updatableColumns.size();
        ResultColumnList rcl = this.resultSet.getResultColumns();
        for (int index = 0; index < size; ++index) {
            String columnName = this.updatableColumns.get(index);
            TableDescriptor tableDescriptor = targetTable.getTableDescriptor();
            if (tableDescriptor.getColumnDescriptor(columnName) == null) {
                throw StandardException.newException("42X04", columnName);
            }
            for (ResultColumn rc : rcl) {
                if (rc.getSourceTableName() == null || rc.getExpression() == null || !rc.getExpression().getColumnName().equals(columnName) || rc.getName().equals(columnName)) continue;
                throw StandardException.newException("42X42", columnName);
            }
        }
    }

    String getXML() {
        return null;
    }

    @Override
    public TableDescriptor[] updateIndexStatisticsFor() throws StandardException {
        if (!this.checkIndexStats || this.statsToUpdate == null) {
            return EMPTY_TD_LIST;
        }
        for (int i = this.statsToUpdate.size() - 1; i >= 0; --i) {
            TableDescriptor td = this.statsToUpdate.get(i);
            if (!td.getAndClearIndexStatsIsUpToDate()) continue;
            this.statsToUpdate.remove(i);
        }
        if (this.statsToUpdate.isEmpty()) {
            return EMPTY_TD_LIST;
        }
        TableDescriptor[] tmp = new TableDescriptor[this.statsToUpdate.size()];
        this.statsToUpdate.toArray(tmp);
        this.statsToUpdate.clear();
        return tmp;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.orderByList != null) {
            this.orderByList.acceptChildren(v);
        }
        if (this.offset != null) {
            this.offset.acceptChildren(v);
        }
        if (this.fetchFirst != null) {
            this.fetchFirst.acceptChildren(v);
        }
    }
}

