/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

class SortResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    public boolean distinct;
    public NoPutResultSet source;
    private ColumnOrdering[] order;
    private ColumnOrdering[] savedOrder;
    private SortObserver observer;
    private ExecRow sortTemplateRow;
    public boolean isInSortedOrder;
    private NoPutResultSet originalSource;
    private int maxRowSize;
    private ScanController scanController;
    private ExecRow sortResultRow;
    private ExecRow currSortedRow;
    private boolean nextCalled;
    private int numColumns;
    private long genericSortId;
    private boolean dropGenericSort;
    private boolean sorted;
    public Properties sortProperties = new Properties();

    public SortResultSet(NoPutResultSet s, boolean distinct, boolean isInSortedOrder, int orderingItem, Activation a, int ra, int maxRowSize, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.distinct = distinct;
        this.isInSortedOrder = isInSortedOrder;
        this.source = s;
        this.originalSource = s;
        this.maxRowSize = maxRowSize;
        ExecPreparedStatement ps = a.getPreparedStatement();
        this.sortTemplateRow = ((ExecRowBuilder)ps.getSavedObject(ra)).build(a.getExecutionFactory());
        this.order = (ColumnOrdering[])((FormatableArrayHolder)ps.getSavedObject(orderingItem)).getArray(ColumnOrdering[].class);
        this.savedOrder = this.order;
        this.observer = new BasicSortObserver(true, distinct, this.sortTemplateRow, true);
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.nextCalled = false;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "SortResultSet already open");
        this.order = this.savedOrder;
        this.sortResultRow = this.sortTemplateRow.getClone();
        this.source.openCore();
        try {
            if (this.isInSortedOrder && this.distinct) {
                this.currSortedRow = this.getNextRowFromRS();
                if (this.currSortedRow != null) {
                    this.currSortedRow = this.currSortedRow.getClone();
                }
            } else {
                this.scanController = this.loadSorter();
                this.sorted = true;
            }
        }
        catch (StandardException e) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw e;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private ScanController loadSorter() throws StandardException {
        ExecRow inputRow;
        boolean inOrder = this.order.length == 0 || this.isInSortedOrder;
        int inputRowCountEstimate = (int)this.optimizerEstimatedRowCount;
        TransactionController tc = this.getTransactionController();
        long sortId = tc.createSort(null, this.sortTemplateRow.getRowArray(), this.order, this.observer, inOrder, inputRowCountEstimate, this.maxRowSize);
        SortController sorter = tc.openSort(sortId);
        this.genericSortId = sortId;
        this.dropGenericSort = true;
        while ((inputRow = this.getNextRowFromRS()) != null) {
            sorter.insert(inputRow.getRowArray());
        }
        this.source.close();
        this.sortProperties = sorter.getSortInfo().getAllSortInfo(this.sortProperties);
        sorter.completedInserts();
        return tc.openSortScan(sortId, this.activation.getResultSetHoldability());
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (!this.isOpen) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isInSortedOrder && this.distinct) {
            if (this.currSortedRow == null) {
                this.nextTime += this.getElapsedMillis(this.beginTime);
                return null;
            }
            if (!this.nextCalled) {
                this.nextCalled = true;
                this.numColumns = this.currSortedRow.getRowArray().length;
                this.nextTime += this.getElapsedMillis(this.beginTime);
                ++this.rowsReturned;
                this.setCurrentRow(this.currSortedRow);
                return this.currSortedRow;
            }
            ExecRow sortResult = this.getNextRowFromRS();
            while (sortResult != null) {
                if (!this.filterRow(this.currSortedRow, sortResult)) {
                    this.currSortedRow = sortResult.getClone();
                    this.setCurrentRow(this.currSortedRow);
                    this.nextTime += this.getElapsedMillis(this.beginTime);
                    ++this.rowsReturned;
                    return this.currSortedRow;
                }
                sortResult = this.getNextRowFromRS();
            }
            this.currSortedRow = null;
            this.nextTime += this.getElapsedMillis(this.beginTime);
            return null;
        }
        ExecRow sortResult = this.getNextRowFromRS();
        if (sortResult != null) {
            this.setCurrentRow(sortResult);
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return sortResult;
    }

    private boolean filterRow(ExecRow currRow, ExecRow newRow) throws StandardException {
        for (int index = 1; index <= this.numColumns; ++index) {
            DataValueDescriptor newOrderable;
            DataValueDescriptor currOrderable = currRow.getColumn(index);
            if (currOrderable.compare(2, newOrderable = newRow.getColumn(index), true, true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.sortResultRow = null;
            this.closeSource();
            if (this.dropGenericSort) {
                this.getTransactionController().dropSort(this.genericSortId);
                this.dropGenericSort = false;
            }
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of SortResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.isOpen = false;
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.originalSource.getTimeSpent(1);
        }
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rl = this.scanController.newRowLocationTemplate();
        this.scanController.fetchLocation(rl);
        return rl;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT(this.isOpen, "SortResultSet expected to be open");
        return this.currentRow;
    }

    private ExecRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecRow getRowFromResultSet() throws StandardException {
        ExecRow sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            ++this.rowsInput;
        }
        return sourceRow;
    }

    private ExecRow getRowFromSorter() throws StandardException {
        ExecRow inputRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow;
            inputRow = this.sortResultRow;
            this.scanController.fetch(inputRow.getRowArray());
        }
        return inputRow;
    }

    private void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close();
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }
}

