/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.dsfactory;

import java.util.Iterator;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.dsfactory.DataSourceFactory;

public abstract class AbstractDataSourceFactory
implements DataSourceFactory {
    public static final String POOL_KEY = "pool";
    public static final String CONNECTION_KEY = "connection";
    public static final String DEFAULTS_KEY = "defaults";
    public static final String DEFAULT_POOL_KEY = "defaults.pool";
    public static final String DEFAULT_CONNECTION_KEY = "defaults.connection";
    private static final Logger log = LogManager.getLogger(AbstractDataSourceFactory.class);

    protected void setProperty(String property, Configuration c, Object ds) throws Exception {
        if (c == null || c.isEmpty()) {
            return;
        }
        String key = property;
        Class<?> dsClass = ds.getClass();
        int dot = property.indexOf(46);
        try {
            if (dot > 0) {
                property = property.substring(0, dot);
                MappedPropertyDescriptor mappedPD = new MappedPropertyDescriptor(property, dsClass);
                Class propertyType = mappedPD.getMappedPropertyType();
                Configuration subProps = c.subset(property);
                Iterator j = subProps.getKeys();
                while (j.hasNext()) {
                    String subProp = (String)j.next();
                    String propVal = subProps.getString(subProp);
                    Object value = ConvertUtils.convert((String)propVal, (Class)propertyType);
                    PropertyUtils.setMappedProperty((Object)ds, (String)property, (String)subProp, (Object)value);
                    log.debug("setMappedProperty({}, {}, {}, {})", ds, (Object)property, (Object)subProp, value);
                }
            } else if ("password".equals(key)) {
                String value = c.getString(property);
                PropertyUtils.setSimpleProperty((Object)ds, (String)property, (Object)value);
                log.debug("setSimpleProperty({}, {}, (value not logged))", ds, (Object)property);
            } else {
                Class propertyType = PropertyUtils.getPropertyType((Object)ds, (String)property);
                Object value = ConvertUtils.convert((String)c.getString(property), (Class)propertyType);
                PropertyUtils.setSimpleProperty((Object)ds, (String)property, (Object)value);
                log.debug("setSimpleProperty({}, {}, {})", ds, (Object)property, value);
            }
        }
        catch (RuntimeException e) {
            throw new TorqueRuntimeException("Runtime error setting property " + property, e);
        }
        catch (Exception e) {
            log.error("Property: {}  value: {}  is not supported by DataSource: {}", (Object)property, (Object)c.getString(key), (Object)ds.getClass().getName());
        }
    }

    protected void applyConfiguration(Configuration c, Object o) throws TorqueException {
        log.debug("applyConfiguration({}, {})", (Object)c, o);
        if (c != null) {
            try {
                Iterator i = c.getKeys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    this.setProperty(key, c, o);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new TorqueException(e);
            }
        }
    }

    protected void initCPDS(Configuration configuration, ConnectionPoolDataSource cpds) throws TorqueException {
        Configuration conf;
        log.debug("Starting initCPDS");
        Configuration c = Torque.getConfiguration();
        if (c == null || c.isEmpty()) {
            log.warn("Global Configuration not set, no Default connection pool data source configured!");
        } else {
            conf = c.subset(DEFAULT_CONNECTION_KEY);
            this.applyConfiguration(conf, cpds);
        }
        conf = configuration.subset(CONNECTION_KEY);
        this.applyConfiguration(conf, cpds);
    }

    protected void initJdbc2Pool(DataSource dataSource, Configuration configuration) throws TorqueException {
        Configuration conf;
        log.debug("Starting initJdbc2Pool");
        Configuration c = Torque.getConfiguration();
        if (c == null || c.isEmpty()) {
            log.warn("Global Configuration not set, no Default pool data source configured!");
        } else {
            conf = c.subset(DEFAULT_POOL_KEY);
            this.applyConfiguration(conf, dataSource);
        }
        conf = configuration.subset(POOL_KEY);
        this.applyConfiguration(conf, dataSource);
    }

    @Override
    public abstract DataSource getDataSource() throws TorqueException;

    @Override
    public abstract void initialize(Configuration var1) throws TorqueException;
}

