/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.data.input.ByteBufferInputRowParser;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.protobuf.FileBasedProtobufBytesDecoder;
import org.apache.druid.data.input.protobuf.ProtobufBytesDecoder;
import org.apache.druid.data.input.protobuf.ProtobufInputRowSchema;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.Parser;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;

public class ProtobufInputRowParser
implements ByteBufferInputRowParser {
    private final ParseSpec parseSpec;
    private final TimestampSpec timestampSpec;
    private final boolean isFlatSpec;
    private final ProtobufBytesDecoder protobufBytesDecoder;
    private Parser<String, Object> parser;
    private final List<String> dimensions;

    @JsonCreator
    public ProtobufInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="protoBytesDecoder") ProtobufBytesDecoder protobufBytesDecoder, @Deprecated @JsonProperty(value="descriptor") String descriptorFilePath, @Deprecated @JsonProperty(value="protoMessageType") String protoMessageType) {
        this.parseSpec = parseSpec;
        this.dimensions = parseSpec.getDimensionsSpec().getDimensionNames();
        this.isFlatSpec = parseSpec instanceof JSONParseSpec && ((JSONPathSpec)((JSONParseSpec)parseSpec).getFlattenSpec()).getFields().isEmpty();
        this.protobufBytesDecoder = descriptorFilePath != null || protoMessageType != null ? new FileBasedProtobufBytesDecoder(descriptorFilePath, protoMessageType) : protobufBytesDecoder;
        this.timestampSpec = this.isFlatSpec ? new ProtobufInputRowSchema.ProtobufTimestampSpec(parseSpec.getTimestampSpec()) : parseSpec.getTimestampSpec();
    }

    @JsonProperty(value="parseSpec")
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @JsonProperty(value="protoBytesDecoder")
    public ProtobufBytesDecoder getProtobufBytesDecoder() {
        return this.protobufBytesDecoder;
    }

    public ProtobufInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new ProtobufInputRowParser(parseSpec, this.protobufBytesDecoder, null, null);
    }

    public List<InputRow> parseBatch(ByteBuffer input) {
        DateTime timestamp;
        Map record;
        DynamicMessage message;
        if (this.parser == null) {
            this.parser = this.parseSpec.makeParser();
        }
        if (this.isFlatSpec) {
            try {
                message = this.protobufBytesDecoder.parse(input);
                record = CollectionUtils.mapKeys(message.getAllFields(), k -> k.getJsonName());
                timestamp = this.timestampSpec.extractTimestamp(record);
            }
            catch (Exception ex) {
                throw new ParseException(null, (Throwable)ex, "Protobuf message could not be parsed", new Object[0]);
            }
        }
        try {
            message = this.protobufBytesDecoder.parse(input);
            String json = JsonFormat.printer().print(message);
            record = this.parser.parseToMap(json);
            timestamp = this.timestampSpec.extractTimestamp(record);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ParseException(null, (Throwable)e, "Protobuf message could not be parsed", new Object[0]);
        }
        ArrayList dimensions = !this.dimensions.isEmpty() ? this.dimensions : Lists.newArrayList((Iterable)Sets.difference(record.keySet(), (Set)this.parseSpec.getDimensionsSpec().getDimensionExclusions()));
        return ImmutableList.of((Object)new MapBasedInputRow(timestamp, (List)dimensions, record));
    }
}

