/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import org.schemarepo.BaseRepository;
import org.schemarepo.InMemorySubjectCache;
import org.schemarepo.Subject;
import org.schemarepo.SubjectConfig;
import org.schemarepo.ValidatorFactory;

public abstract class AbstractBackendRepository
extends BaseRepository {
    protected final InMemorySubjectCache subjectCache = new InMemorySubjectCache();
    protected final ValidatorFactory validators;

    protected AbstractBackendRepository(ValidatorFactory validators) {
        this.validators = validators != null ? validators : ValidatorFactory.EMPTY;
    }

    protected abstract Subject getSubjectInstance(String var1);

    protected final Subject getAndCacheSubject(String subjectName) {
        return this.cacheSubject(this.getSubjectInstance(subjectName));
    }

    protected final Subject cacheSubject(Subject subject) {
        return this.subjectCache.add(Subject.validatingSubject(subject, this.validators));
    }

    @Override
    public synchronized Subject register(String subjectName, SubjectConfig config) {
        this.isValid();
        Subject subject = this.subjectCache.lookup(subjectName);
        if (subject == null) {
            this.registerSubjectInBackend(subjectName, config);
            subject = this.getAndCacheSubject(subjectName);
        } else {
            this.logger.debug("Subject {} already exists, reusing", (Object)subjectName);
        }
        return subject;
    }

    protected abstract void registerSubjectInBackend(String var1, SubjectConfig var2);

    @Override
    public synchronized Subject lookup(String subjectName) {
        this.isValid();
        Subject subject = this.subjectCache.lookup(subjectName);
        if (subject == null && this.checkSubjectExistsInBackend(subjectName)) {
            subject = this.getAndCacheSubject(subjectName);
        }
        return subject;
    }

    protected boolean checkSubjectExistsInBackend(String subjectName) {
        return false;
    }

    @Override
    public synchronized Iterable<Subject> subjects() {
        this.isValid();
        return this.subjectCache.values();
    }
}

