/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.compare;

import java.util.Set;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBExistsExpr
extends DBCompareExpr {
    private static final Logger log = LoggerFactory.getLogger(DBExistsExpr.class);
    public final DBCommandExpr cmd;
    public final DBCompareExpr compareExpr;

    public DBExistsExpr(DBCommandExpr cmd) {
        this(cmd, null);
    }

    public DBExistsExpr(DBCommandExpr cmd, DBCompareExpr compareExpr) {
        this.cmd = cmd;
        this.compareExpr = compareExpr;
    }

    public final DBDatabase getDatabase() {
        return this.cmd.getDatabase();
    }

    @Override
    public DBRowSet getRowSet() {
        return this.compareExpr != null ? this.compareExpr.getRowSet() : null;
    }

    @Override
    public void prepareParams(DBCommand cmd, DBExpr parent) {
        if (this.compareExpr != null) {
            this.compareExpr.prepareParams(cmd, this);
        }
    }

    @Override
    public DBCompareExpr copy(DBCommand newCmd) {
        if (this.compareExpr == null) {
            return this;
        }
        return new DBExistsExpr(this.cmd, this.compareExpr.copy(newCmd));
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 4L) == 0L) {
            log.warn("cannot add name only of exits expression");
            return;
        }
        if ((context & 1L) == 0L) {
            log.warn("cannot add value only of exits expression");
            return;
        }
        sql.append(" exists (");
        this.cmd.getSelect(sql, 16);
        if (this.compareExpr != null) {
            if (this.cmd instanceof DBCommand && ((DBCommand)this.cmd).getWhereConstraints() == null) {
                sql.append(" where ");
            } else {
                sql.append(" and ");
            }
            sql.append("(");
            this.compareExpr.addSQL(sql, context);
            sql.append(") ");
        }
        sql.append(") ");
    }

    @Override
    public boolean isMutuallyExclusive(DBCompareExpr other) {
        if (other instanceof DBExistsExpr) {
            DBExistsExpr o = (DBExistsExpr)other;
            if (this.cmd.equals(o.cmd) && this.compareExpr.equals(o.compareExpr)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConstraintOn(DBColumnExpr colExpr) {
        return this.compareExpr != null ? this.compareExpr.isConstraintOn(colExpr) : false;
    }
}

