/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.Objects;
import java.util.Optional;

@Internal
class NettyStreamedHttpResponse<B>
implements MutableHttpResponse<B>,
NettyHttpResponseBuilder {
    private final StreamedHttpResponse nettyResponse;
    private HttpStatus status;
    private final NettyHttpHeaders headers;
    @GuardedBy(value="this")
    private NettyCookies nettyCookies;
    private B body;
    private volatile MutableConvertibleValues<Object> attributes;

    NettyStreamedHttpResponse(StreamedHttpResponse response, HttpStatus httpStatus) {
        this.nettyResponse = response;
        this.status = httpStatus;
        this.headers = new NettyHttpHeaders(response.headers(), ConversionService.SHARED);
    }

    public StreamedHttpResponse getNettyResponse() {
        return this.nettyResponse;
    }

    @Override
    public String reason() {
        return this.nettyResponse.status().reasonPhrase();
    }

    @Override
    public HttpStatus getStatus() {
        return this.status;
    }

    @Override
    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValues<Object> attributes = this.attributes;
        if (attributes == null) {
            NettyStreamedHttpResponse nettyStreamedHttpResponse = this;
            synchronized (nettyStreamedHttpResponse) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap<Object>();
                }
            }
        }
        return attributes;
    }

    public void setBody(B body2) {
        this.body = body2;
    }

    @Override
    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    @Override
    @NonNull
    public FullHttpResponse toFullHttpResponse() {
        throw new UnsupportedOperationException("Cannot convert a stream response to a full response");
    }

    @Override
    @NonNull
    public StreamedHttpResponse toStreamHttpResponse() {
        return this.nettyResponse;
    }

    @Override
    @NonNull
    public HttpResponse toHttpResponse() {
        return this.nettyResponse;
    }

    @Override
    public boolean isStream() {
        return true;
    }

    @Override
    public synchronized MutableHttpResponse<B> cookie(Cookie cookie) {
        if (!(cookie instanceof NettyCookie)) {
            throw new IllegalArgumentException("Argument is not a Netty compatible Cookie");
        }
        NettyCookie nettyCookie = (NettyCookie)cookie;
        String value = ServerCookieEncoder.STRICT.encode(nettyCookie.getNettyCookie());
        this.headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, value);
        this.nettyCookies = null;
        return this;
    }

    @Override
    public synchronized Cookies getCookies() {
        if (this.nettyCookies == null) {
            this.nettyCookies = new NettyCookies(this.nettyResponse.headers(), ConversionService.SHARED);
        }
        return this.nettyCookies;
    }

    @Override
    public Optional<Cookie> getCookie(String name) {
        return this.getCookies().findCookie(name);
    }

    @Override
    public <T> MutableHttpResponse<T> body(@Nullable T body2) {
        this.body = body2;
        return this;
    }

    @Override
    public MutableHttpResponse<B> status(HttpStatus status, CharSequence message) {
        this.status = Objects.requireNonNull(status, "Status is required");
        return this;
    }
}

