/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.jvm;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.NonNullApi;

@NonNullApi
public class JavaVersionParser {
    public static int parseMajorVersion(String fullVersion) {
        int firstNonVersionCharIndex = JavaVersionParser.findFirstNonVersionCharIndex(fullVersion);
        String[] versionStrings = fullVersion.substring(0, firstNonVersionCharIndex).split("\\.");
        List<Integer> versions = JavaVersionParser.convertToNumber(fullVersion, versionStrings);
        if (JavaVersionParser.isLegacyVersion(versions)) {
            JavaVersionParser.assertTrue(fullVersion, versions.get(1) > 0);
            return versions.get(1);
        }
        return versions.get(0);
    }

    private static void assertTrue(String value, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("Could not determine Java version from '" + value + "'.");
        }
    }

    private static boolean isLegacyVersion(List<Integer> versions) {
        return 1 == versions.get(0) && versions.size() > 1;
    }

    private static List<Integer> convertToNumber(String value, String[] versionStrs) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : versionStrs) {
            JavaVersionParser.assertTrue(value, !JavaVersionParser.isNumberStartingWithZero(s));
            try {
                result.add(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                JavaVersionParser.assertTrue(value, false);
            }
        }
        JavaVersionParser.assertTrue(value, !result.isEmpty() && (Integer)result.get(0) > 0);
        return result;
    }

    private static boolean isNumberStartingWithZero(String number) {
        return number.length() > 1 && number.startsWith("0");
    }

    private static int findFirstNonVersionCharIndex(String s) {
        JavaVersionParser.assertTrue(s, !s.isEmpty());
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (JavaVersionParser.isDigitOrPeriod(s.charAt(i2))) continue;
            JavaVersionParser.assertTrue(s, i2 != 0);
            return i2;
        }
        return s.length();
    }

    private static boolean isDigitOrPeriod(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }
}

