/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.common.collect;

import java.util.Comparator;
import java.util.Spliterator;
import org.gradle.internal.impldep.com.google.common.annotations.GwtCompatible;
import org.gradle.internal.impldep.com.google.common.annotations.GwtIncompatible;
import org.gradle.internal.impldep.com.google.common.annotations.J2ktIncompatible;
import org.gradle.internal.impldep.com.google.common.collect.CollectSpliterators;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.RegularImmutableAsList;
import org.gradle.internal.impldep.com.google.common.collect.RegularImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.SortedIterable;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;

@GwtCompatible(emulated=true)
final class ImmutableSortedAsList<E>
extends RegularImmutableAsList<E>
implements SortedIterable<E> {
    ImmutableSortedAsList(ImmutableSortedSet<E> backingSet, ImmutableList<E> backingList) {
        super(backingSet, backingList);
    }

    @Override
    ImmutableSortedSet<E> delegateCollection() {
        return (ImmutableSortedSet)super.delegateCollection();
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.delegateCollection()).comparator();
    }

    @Override
    @GwtIncompatible
    public int indexOf(@Nullable Object target) {
        int index2 = ((ImmutableSortedSet)this.delegateCollection()).indexOf(target);
        return index2 >= 0 && this.get(index2).equals(target) ? index2 : -1;
    }

    @Override
    @GwtIncompatible
    public int lastIndexOf(@Nullable Object target) {
        return this.indexOf(target);
    }

    @Override
    public boolean contains(@Nullable Object target) {
        return this.indexOf(target) >= 0;
    }

    @Override
    @GwtIncompatible
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        ImmutableList parentSubList = super.subListUnchecked(fromIndex, toIndex);
        return new RegularImmutableSortedSet(parentSubList, this.comparator()).asList();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1301, this.delegateList()::get, this.comparator());
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

