/*
 * Decompiled with CFR 0.152.
 */
package org.grails.build.parsing;

import grails.util.Environment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.grails.build.parsing.CommandLine;
import org.grails.build.parsing.CommandLineParser;
import org.grails.build.parsing.Option;

public class DefaultCommandLine
implements CommandLine {
    Properties systemProperties = new Properties();
    LinkedHashMap<String, Object> undeclaredOptions = new LinkedHashMap();
    LinkedHashMap<String, SpecifiedOption> declaredOptions = new LinkedHashMap();
    List<String> remainingArgs = new ArrayList<String>();
    private String environment;
    private String commandName;
    private String[] rawArguments;

    public void addDeclaredOption(String name, Option option) {
        this.addDeclaredOption(name, option, Boolean.TRUE);
    }

    public void addUndeclaredOption(String option) {
        this.undeclaredOptions.put(option, Boolean.TRUE);
    }

    public void addUndeclaredOption(String option, Object value) {
        this.undeclaredOptions.put(option, value);
    }

    public void addDeclaredOption(String name, Option option, Object value) {
        SpecifiedOption so = new SpecifiedOption();
        so.option = option;
        so.value = value;
        this.declaredOptions.put(name, so);
    }

    @Override
    public CommandLine parseNew(String[] args) {
        DefaultCommandLine defaultCommandLine = new DefaultCommandLine();
        defaultCommandLine.systemProperties.putAll((Map<?, ?>)this.systemProperties);
        defaultCommandLine.undeclaredOptions.putAll(this.undeclaredOptions);
        defaultCommandLine.declaredOptions.putAll(this.declaredOptions);
        CommandLineParser parser = new CommandLineParser();
        return parser.parse(defaultCommandLine, args);
    }

    public void setEnvironment(String environment2) {
        this.environment = environment2;
        System.setProperty(Environment.KEY, environment2);
    }

    @Override
    public void setCommand(String name) {
        this.commandName = name;
    }

    @Override
    public String getEnvironment() {
        String env;
        boolean useDefaultEnv;
        boolean bl = useDefaultEnv = this.environment == null;
        if (useDefaultEnv && this.commandName != null) {
            env = this.lookupEnvironmentForCommand();
        } else {
            String fallbackEnv = System.getProperty(Environment.KEY) != null ? System.getProperty(Environment.KEY) : Environment.DEVELOPMENT.getName();
            env = this.environment != null ? this.environment : fallbackEnv;
        }
        System.setProperty(Environment.KEY, env);
        System.setProperty("grails.env.default", String.valueOf(useDefaultEnv));
        return env;
    }

    @Override
    public String lookupEnvironmentForCommand() {
        String fallbackEnv = System.getProperty(Environment.KEY) != null ? System.getProperty(Environment.KEY) : Environment.DEVELOPMENT.getName();
        String env = CommandLineParser.DEFAULT_ENVS.get(this.commandName);
        return env == null ? fallbackEnv : env;
    }

    @Override
    public boolean isEnvironmentSet() {
        return this.environment != null;
    }

    public void setCommandName(String cmd) {
        if ("refresh-dependencies".equals(cmd)) {
            this.addUndeclaredOption("refresh-dependencies");
        }
        this.commandName = cmd;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    public void addRemainingArg(String arg) {
        this.remainingArgs.add(arg);
    }

    @Override
    public List<String> getRemainingArgs() {
        return this.remainingArgs;
    }

    @Override
    public String[] getRemainingArgsArray() {
        return this.remainingArgs.toArray(new String[this.remainingArgs.size()]);
    }

    @Override
    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public boolean hasOption(String name) {
        return this.declaredOptions.containsKey(name) || this.undeclaredOptions.containsKey(name);
    }

    @Override
    public Object optionValue(String name) {
        if (this.declaredOptions.containsKey(name)) {
            SpecifiedOption specifiedOption = this.declaredOptions.get(name);
            return specifiedOption.value;
        }
        if (this.undeclaredOptions.containsKey(name)) {
            return this.undeclaredOptions.get(name);
        }
        return null;
    }

    @Override
    public Map.Entry<String, Object> lastOption() {
        Iterator<Map.Entry<String, Object>> i2 = this.undeclaredOptions.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry<String, Object> next = i2.next();
            if (i2.hasNext()) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getRemainingArgsString() {
        return this.remainingArgsToString(" ", false);
    }

    @Override
    public String getRemainingArgsWithOptionsString() {
        return this.remainingArgsToString(" ", true);
    }

    @Override
    public String getRemainingArgsLineSeparated() {
        return this.remainingArgsToString("\n", false);
    }

    private String remainingArgsToString(String separator, boolean includeOptions) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        ArrayList<String> args = new ArrayList<String>(this.remainingArgs);
        if (includeOptions) {
            for (Map.Entry entry : this.undeclaredOptions.entrySet()) {
                if (entry.getValue() instanceof Boolean && ((Boolean)entry.getValue()).booleanValue()) {
                    args.add("-" + (String)entry.getKey());
                    continue;
                }
                args.add("-" + (String)entry.getKey() + "=" + String.valueOf(entry.getValue()));
            }
        }
        for (String string : args) {
            sb.append(sep).append(string);
            sep = separator;
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> getUndeclaredOptions() {
        return this.undeclaredOptions;
    }

    public void addSystemProperty(String name, String value) {
        if (Environment.KEY.equals(name)) {
            this.setEnvironment(value);
        }
        this.systemProperties.put(name, value);
    }

    public void setRawArguments(String[] args) {
        this.rawArguments = args;
    }

    @Override
    public String[] getRawArguments() {
        return this.rawArguments;
    }

    public static class SpecifiedOption {
        private Option option;
        private Object value;

        public Option getOption() {
            return this.option;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

