/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.h2;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.h2.console")
public class H2ConsoleProperties {
    private String path = "/h2-console";
    private boolean enabled;
    private final Settings settings = new Settings();

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        Assert.notNull((Object)path, "'path' must not be null");
        Assert.isTrue(path.length() > 1, "'path' must have length greater than 1");
        Assert.isTrue(path.startsWith("/"), "'path' must start with '/'");
        this.path = path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public static class Settings {
        private boolean trace;
        private boolean webAllowOthers;
        private String webAdminPassword;

        public boolean isTrace() {
            return this.trace;
        }

        public void setTrace(boolean trace) {
            this.trace = trace;
        }

        public boolean isWebAllowOthers() {
            return this.webAllowOthers;
        }

        public void setWebAllowOthers(boolean webAllowOthers) {
            this.webAllowOthers = webAllowOthers;
        }

        public String getWebAdminPassword() {
            return this.webAdminPassword;
        }

        public void setWebAdminPassword(String webAdminPassword) {
            this.webAdminPassword = webAdminPassword;
        }
    }
}

