/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import java.util.Arrays;
import org.apache.gravitino.dto.authorization.GroupDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class GroupListResponse
extends BaseResponse {
    @JsonProperty(value="groups")
    private final GroupDTO[] groups;

    public GroupListResponse(GroupDTO[] groups) {
        super(0);
        this.groups = groups;
    }

    public GroupListResponse() {
        this.groups = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.groups != null, "groups must not be null");
        Arrays.stream(this.groups).forEach(group -> {
            Preconditions.checkArgument(StringUtils.isNotBlank(group.name()), "group 'name' must not be blank");
            Preconditions.checkArgument(group.auditInfo() != null, "group 'auditInfo' must not be null");
        });
    }

    public GroupDTO[] getGroups() {
        return this.groups;
    }

    @Override
    public String toString() {
        return "GroupListResponse(groups=" + Arrays.deepToString(this.getGroups()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupListResponse)) {
            return false;
        }
        GroupListResponse other = (GroupListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getGroups(), other.getGroups());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GroupListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getGroups());
        return result;
    }
}

