/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.entry;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.Writable;
import org.apache.hugegraph.computer.core.sort.sorter.JavaInputSorter;
import org.apache.hugegraph.computer.core.store.buffer.KvEntriesInput;
import org.apache.hugegraph.computer.core.store.entry.EntriesUtil;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.entry.KvEntryWriter;

public class KvEntryWriterImpl
implements KvEntryWriter {
    private final RandomAccessOutput output;
    private final long placeholderPosition;
    private final boolean needSort;
    private long total;
    private int subEntryCount;
    private final BytesOutput subKvBuffer;

    public KvEntryWriterImpl(RandomAccessOutput output, boolean needSort) {
        this.output = output;
        this.placeholderPosition = output.position();
        try {
            this.output.writeFixedInt(0);
            this.output.writeFixedInt(0);
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
        this.needSort = needSort;
        this.total = 0L;
        this.subEntryCount = 0;
        this.subKvBuffer = needSort ? IOFactory.createBytesOutput(8192) : null;
    }

    @Override
    public void writeSubKv(Writable subKey, Writable subValue) throws IOException {
        this.writeData(subKey);
        this.writeData(subValue);
        ++this.subEntryCount;
    }

    @Override
    public void writeFinish() throws IOException {
        this.output.writeFixedInt(this.placeholderPosition, (int)this.total + 4);
        this.output.writeFixedInt(this.placeholderPosition + 4L, this.subEntryCount);
        if (this.needSort) {
            this.sortAndWriteSubKvs();
        }
    }

    private void sortAndWriteSubKvs() throws IOException {
        BytesInput input = EntriesUtil.inputFromOutput(this.subKvBuffer);
        JavaInputSorter sorter = new JavaInputSorter();
        Iterator<KvEntry> subKvs = sorter.sort((Iterator<KvEntry>)((Object)new KvEntriesInput((RandomAccessInput)input)));
        while (subKvs.hasNext()) {
            KvEntry subKv = subKvs.next();
            subKv.key().write(this.output);
            subKv.value().write(this.output);
        }
    }

    private void writeData(Writable data) throws IOException {
        RandomAccessOutput output;
        if (this.needSort) {
            assert (this.subKvBuffer != null);
            output = this.subKvBuffer;
        } else {
            output = this.output;
        }
        long position = output.position();
        output.writeFixedInt(0);
        data.write(output);
        long dataLength = output.position() - position - 4L;
        output.writeFixedInt(position, (int)dataLength);
        this.total += 4L + dataLength;
    }
}

