/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.MockSerializable;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class VariablesTest {

    @RunWith(value=Parameterized.class)
    public static class GraphVariablesFeatureSupportTest
    extends AbstractGremlinTest {
        private static final Map<String, Object> testMap = new HashMap<String, Object>();
        private static final ArrayList<Object> mixedList = new ArrayList();
        private static final ArrayList<String> uniformStringList = new ArrayList();
        private static final ArrayList<Integer> uniformIntegerList = new ArrayList();
        @Parameterized.Parameter(value=0)
        public String featureName;
        @Parameterized.Parameter(value=1)
        public Object value;

        @Parameterized.Parameters(name="supports{0}({1})")
        public static Iterable<Object[]> data() {
            return Arrays.asList({"BooleanValues", true}, {"BooleanValues", false}, {"DoubleValues", Double.MIN_VALUE}, {"DoubleValues", Double.MAX_VALUE}, {"DoubleValues", 0.0}, {"DoubleValues", 0.5}, {"DoubleValues", -0.5}, {"FloatValues", Float.valueOf(Float.MIN_VALUE)}, {"FloatValues", Float.valueOf(Float.MAX_VALUE)}, {"FloatValues", Float.valueOf(0.0f)}, {"FloatValues", Float.valueOf(0.5f)}, {"FloatValues", Float.valueOf(-0.5f)}, {"IntegerValues", Integer.MIN_VALUE}, {"IntegerValues", Integer.MAX_VALUE}, {"IntegerValues", 0}, {"IntegerValues", 10000}, {"IntegerValues", -10000}, {"LongValues", Long.MIN_VALUE}, {"LongValues", Long.MAX_VALUE}, {"LongValues", 0L}, {"LongValues", 10000L}, {"LongValues", -10000L}, {"MapValues", testMap}, {"MixedListValues", mixedList}, {"BooleanArrayValues", new boolean[]{true, false}}, {"DoubleArrayValues", new double[]{1.0, 2.0}}, {"FloatArrayValues", new float[]{1.0f, 2.0f}}, {"IntegerArrayValues", new int[]{1, 2}}, {"LongArrayValues", new long[]{1L, 2L}}, {"StringArrayValues", new String[]{"try1", "try2"}}, {"IntegerArrayValues", new int[1]}, {"SerializableValues", new MockSerializable("testing")}, {"StringValues", "short string"}, {"UniformListValues", uniformIntegerList}, {"UniformListValues", uniformStringList});
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables")
        public void shouldSetValueOnGraph() throws Exception {
            Assume.assumeThat((Object)this.graph.features().supports(Graph.Features.VariableFeatures.class, this.featureName), (Matcher)CoreMatchers.is((Object)true));
            Graph.Variables variables = this.graph.variables();
            variables.set("aKey", this.value);
            if (this.value instanceof Map) {
                this.tryCommit(this.graph, graph -> {
                    Map map = (Map)variables.get("aKey").get();
                    Assert.assertEquals((long)((Map)this.value).size(), (long)map.size());
                    ((Map)this.value).keySet().forEach(k -> Assert.assertEquals(((Map)this.value).get(k), map.get(k)));
                });
            } else if (this.value instanceof List) {
                this.tryCommit(this.graph, graph -> {
                    List l = (List)variables.get("aKey").get();
                    Assert.assertEquals((long)((List)this.value).size(), (long)l.size());
                    for (int ix = 0; ix < ((List)this.value).size(); ++ix) {
                        Assert.assertEquals(((List)this.value).get(ix), l.get(ix));
                    }
                });
            } else if (this.value instanceof MockSerializable) {
                this.tryCommit(this.graph, graph -> {
                    MockSerializable mock = (MockSerializable)variables.get("aKey").get();
                    Assert.assertEquals((Object)((MockSerializable)this.value).getTestField(), (Object)mock.getTestField());
                });
            } else if (this.value instanceof boolean[]) {
                this.tryCommit(this.graph, graph -> {
                    boolean[] l = (boolean[])variables.get("aKey").get();
                    Assert.assertEquals((long)((boolean[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((boolean[])this.value).length; ++ix) {
                        Assert.assertEquals((Object)((boolean[])this.value)[ix], (Object)l[ix]);
                    }
                });
            } else if (this.value instanceof double[]) {
                this.tryCommit(this.graph, graph -> {
                    double[] l = (double[])variables.get("aKey").get();
                    Assert.assertEquals((long)((double[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((double[])this.value).length; ++ix) {
                        Assert.assertEquals((double)((double[])this.value)[ix], (double)l[ix], (double)0.0);
                    }
                });
            } else if (this.value instanceof float[]) {
                this.tryCommit(this.graph, graph -> {
                    float[] l = (float[])variables.get("aKey").get();
                    Assert.assertEquals((long)((float[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((float[])this.value).length; ++ix) {
                        Assert.assertEquals((float)((float[])this.value)[ix], (float)l[ix], (float)0.0f);
                    }
                });
            } else if (this.value instanceof int[]) {
                this.tryCommit(this.graph, graph -> {
                    int[] l = (int[])variables.get("aKey").get();
                    Assert.assertEquals((long)((int[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((int[])this.value).length; ++ix) {
                        Assert.assertEquals((long)((int[])this.value)[ix], (long)l[ix]);
                    }
                });
            } else if (this.value instanceof long[]) {
                this.tryCommit(this.graph, graph -> {
                    long[] l = (long[])variables.get("aKey").get();
                    Assert.assertEquals((long)((long[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((long[])this.value).length; ++ix) {
                        Assert.assertEquals((long)((long[])this.value)[ix], (long)l[ix]);
                    }
                });
            } else if (this.value instanceof String[]) {
                this.tryCommit(this.graph, graph -> {
                    String[] l = (String[])variables.get("aKey").get();
                    Assert.assertEquals((long)((String[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((String[])this.value).length; ++ix) {
                        Assert.assertEquals((Object)((String[])this.value)[ix], (Object)l[ix]);
                    }
                });
            } else {
                this.tryCommit(this.graph, graph -> Assert.assertEquals((Object)this.value, variables.get("aKey").get()));
            }
        }

        static {
            testMap.put("testString", "try");
            testMap.put("testInteger", 123);
            mixedList.add("try1");
            mixedList.add(2);
            uniformStringList.add("try1");
            uniformStringList.add("try2");
            uniformIntegerList.add(100);
            uniformIntegerList.add(200);
            uniformIntegerList.add(300);
        }
    }

    public static class VariableAsMapTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="StringValues")})
        public void shouldHoldVariableNone() {
            Graph.Variables variables = this.graph.variables();
            Map mapOfAnnotations = variables.asMap();
            Assert.assertNotNull((Object)mapOfAnnotations);
            Assert.assertEquals((long)0L, (long)mapOfAnnotations.size());
            try {
                mapOfAnnotations.put("something", "can't do this");
                Assert.fail((String)"Should not be able to mutate the Map returned from Graph.variables.getAnnotations()");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="StringValues")})
        public void shouldHoldVariableString() {
            Graph.Variables variables = this.graph.variables();
            variables.set("test1", (Object)"1");
            variables.set("test2", (Object)"2");
            variables.set("test3", (Object)"3");
            this.tryCommit(this.graph, graph -> {
                Map m = variables.asMap();
                Assert.assertEquals((Object)"1", m.get("test1"));
                Assert.assertEquals((Object)"2", m.get("test2"));
                Assert.assertEquals((Object)"3", m.get("test3"));
            });
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="IntegerValues")})
        public void shouldHoldVariableInteger() {
            Graph.Variables variables = this.graph.variables();
            variables.set("test1", (Object)1);
            variables.set("test2", (Object)2);
            variables.set("test3", (Object)3);
            this.tryCommit(this.graph, graph -> {
                Map m = variables.asMap();
                Assert.assertEquals((Object)1, m.get("test1"));
                Assert.assertEquals((Object)2, m.get("test2"));
                Assert.assertEquals((Object)3, m.get("test3"));
            });
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="LongValues")})
        public void shouldHoldVariableLong() {
            Graph.Variables variables = this.graph.variables();
            variables.set("test1", (Object)1L);
            variables.set("test2", (Object)2L);
            variables.set("test3", (Object)3L);
            this.tryCommit(this.graph, graph -> {
                Map m = variables.asMap();
                Assert.assertEquals((Object)1L, m.get("test1"));
                Assert.assertEquals((Object)2L, m.get("test2"));
                Assert.assertEquals((Object)3L, m.get("test3"));
            });
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="LongValues")})
        public void shouldHoldVariableMixed() {
            Graph.Variables variables = this.graph.variables();
            variables.set("test1", (Object)"1");
            variables.set("test2", (Object)2);
            variables.set("test3", (Object)3L);
            this.tryCommit(this.graph, graph -> {
                Map m = variables.asMap();
                Assert.assertEquals((Object)"1", m.get("test1"));
                Assert.assertEquals((Object)2, m.get("test2"));
                Assert.assertEquals((Object)3L, m.get("test3"));
            });
        }
    }

    @RunWith(value=Parameterized.class)
    @ExceptionCoverage(exceptionClass=Graph.Variables.Exceptions.class, methods={"variableValueCanNotBeNull", "variableKeyCanNotBeNull", "variableKeyCanNotBeEmpty"})
    public static class VariableExceptionConsistencyTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public String key;
        @Parameterized.Parameter(value=2)
        public String val;
        @Parameterized.Parameter(value=3)
        public Exception expectedException;

        @Parameterized.Parameters(name="expect({0})")
        public static Iterable<Object[]> data() {
            return Arrays.asList({"variableValueCanNotBeNull", "k", null, Graph.Variables.Exceptions.variableValueCanNotBeNull()}, {"variableKeyCanNotBeNull", null, "v", Graph.Variables.Exceptions.variableKeyCanNotBeNull()}, {"variableKeyCanNotBeEmpty", "", "v", Graph.Variables.Exceptions.variableKeyCanNotBeEmpty()});
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables")
        public void testGraphVariablesSet() throws Exception {
            try {
                this.graph.variables().set(this.key, (Object)this.val);
                Assert.fail((String)String.format("Setting an annotation with these arguments [key: %s value: %s] should throw an exception", this.key, this.val));
            }
            catch (Exception ex) {
                VariableExceptionConsistencyTest.validateException(this.expectedException, ex);
            }
        }
    }

    public static class StringRepresentationTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables"), @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="StringValues")})
        public void testVariables() {
            Graph.Variables variables = this.graph.variables();
            variables.set("xo", (Object)"test1");
            variables.set("yo", (Object)"test2");
            variables.set("zo", (Object)"test3");
            this.tryCommit(this.graph, graph -> Assert.assertEquals((Object)StringFactory.graphVariablesString((Graph.Variables)variables), (Object)variables.toString()));
        }
    }
}

