/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.metric;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.metric.MetaSyncInfo;
import org.apache.inlong.sdk.dataproxy.metric.MetricConfig;
import org.apache.inlong.sdk.dataproxy.metric.TrafficInfo;
import org.apache.inlong.sdk.dataproxy.sender.BaseSender;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.apache.inlong.sdk.dataproxy.utils.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDataHolder
implements Runnable {
    private static final String DEFAULT_KEY_SPLITTER = "#";
    private static final Logger logger = LoggerFactory.getLogger(MetricDataHolder.class);
    private final MetricConfig metricConfig;
    private final BaseSender sender;
    private volatile boolean started = true;
    private volatile int itemIndex;
    private final MetricInfoUnit[] metricUnits = new MetricInfoUnit[2];
    private volatile long lstReportTime;
    private final ScheduledExecutorService outputExecutor = Executors.newScheduledThreadPool(1);

    public MetricDataHolder(BaseSender sender) {
        this.sender = sender;
        this.metricConfig = sender.getConfigure().getMetricConfig();
        this.itemIndex = 0;
        this.metricUnits[0] = new MetricInfoUnit();
        this.metricUnits[1] = new MetricInfoUnit();
    }

    public boolean start(ProcessResult procResult) {
        this.outputExecutor.scheduleWithFixedDelay(this, this.metricConfig.getMetricOutIntvlMs(), this.metricConfig.getMetricOutIntvlMs(), TimeUnit.MILLISECONDS);
        logger.info("Metric DataHolder({}) started!", (Object)this.sender.getSenderId());
        return procResult.setSuccess();
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        this.outputMetricData(false, startTime, this.getAndIncIndex());
        long dltTime = System.currentTimeMillis() - startTime;
        if (dltTime > this.metricConfig.getMetricOutWarnIntMs()) {
            logger.warn("Metric DataHolder({}) snapshot finished, cost = {} ms!", (Object)this.sender.getSenderId(), (Object)dltTime);
        }
        this.lstReportTime = startTime;
    }

    public void close() {
        logger.info("Metric DataHolder({}) closing ......", (Object)this.sender.getSenderId());
        long startTime = System.currentTimeMillis();
        this.started = false;
        this.outputExecutor.shutdown();
        this.outputMetricData(true, startTime, this.getOldIndex());
        this.outputMetricData(true, startTime, this.getCurIndex());
        logger.info("Metric DataHolder({}) closed, cost = {} ms!", (Object)this.sender.getSenderId(), (Object)(System.currentTimeMillis() - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetaSyncMetric(int errCode, long syncCostMs) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.metaSyncInfo.addSucMsgInfo(errCode, syncCostMs);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSyncSucMetric(String groupId, String streamId, int msgCnt, long costMs) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addSyncSendSucInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt, costMs);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSyncFailMetric(int errCode, String groupId, String streamId, int msgCnt) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addSyncSendFailInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt, errCode);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncSucReqMetric(String groupId, String streamId, int msgCnt) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addAsyncSendSucInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncFailReqMetric(int errCode, String groupId, String streamId, int msgCnt) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addAsyncSendFailInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt, errCode);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallbackSucMetric(String groupId, String streamId, int msgCnt, long costMs, long callDurMs) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addAsyncRspSucInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt, costMs, callDurMs);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallbackFailMetric(int errCode, String groupId, String streamId, int msgCnt, long costMs) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addAsyncRspFailInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt, errCode, costMs);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncHttpSucPutMetric(String groupId, String streamId, int msgCnt) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addAsyncHttpPutSucInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncHttpFailPutMetric(int errCode, String groupId, String streamId, int msgCnt) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addAsyncHttpPutFailInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt, errCode);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncHttpSucGetMetric(String groupId, String streamId, int msgCnt) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[this.itemIndex];
        selectedUnit.refCnt.incrementAndGet();
        try {
            selectedUnit.addAsyncHttpGetSucInfo(groupId, this.metricConfig.isMaskStreamId() ? "" : streamId, msgCnt);
        }
        finally {
            selectedUnit.refCnt.decrementAndGet();
        }
    }

    private void outputMetricData(boolean forceOutput, long reportTime, int readIndex) {
        if (!this.metricConfig.isEnableMetric()) {
            return;
        }
        if (!forceOutput && !this.started) {
            return;
        }
        MetricInfoUnit selectedUnit = this.metricUnits[readIndex];
        if (selectedUnit == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        while ((forceOutput || this.started) && System.currentTimeMillis() - startTime < 5000L) {
            ProxyUtils.sleepSomeTime(80L);
            if (selectedUnit.refCnt.get() > 0L) continue;
        }
        if (!forceOutput && !this.started) {
            logger.info("Metric DataHolder({}) closed, stop output metric info", (Object)this.sender.getSenderId());
            return;
        }
        StringBuilder strBuff = new StringBuilder(512);
        String rptContent = this.buildMetricReportInfo(strBuff, reportTime, selectedUnit);
        logger.info("Metric DataHolder({}) output metricInfo={}", (Object)this.sender.getSenderId(), (Object)rptContent);
    }

    private int getCurIndex() {
        return this.itemIndex;
    }

    private int getOldIndex() {
        return this.itemIndex ^ 1;
    }

    private int getAndIncIndex() {
        int curIndex = this.itemIndex;
        this.itemIndex = curIndex ^ 1;
        return curIndex;
    }

    private String buildMetricReportInfo(StringBuilder strBuff, long curTimeMs, MetricInfoUnit metricUnit) {
        strBuff.append("{\"type\":\"JAVA\",\"pVer\":1.0,\"ver\":\"").append(ProxyUtils.getJarVersion()).append("\",\"ip\":\"").append(ProxyUtils.getLocalIp()).append("\",\"pid\":").append(ProxyUtils.getProcessPid()).append(",\"sid\":\"").append(this.sender.getSenderId()).append("\",\"rT\":").append(curTimeMs).append(",\"lrT\":").append(this.lstReportTime).append(",");
        metricUnit.getAndResetValue(strBuff);
        Tuple2<Integer, Integer> factoryAvailQuota = this.sender.getFactoryAvailQuota();
        Tuple2<Integer, Integer> senderAvailQuota = this.sender.getSenderAvailQuota();
        strBuff.append(",\"s\":{\"tNs\":").append(this.sender.getProxyNodeCnt()).append(",\"aNs\":").append(this.sender.getActiveNodeCnt()).append(",\"ifRs\":").append(this.sender.getInflightMsgCnt()).append(",\"afPc\":").append(factoryAvailQuota.getF0()).append(",\"afPs\":").append(factoryAvailQuota.getF1()).append(",\"aPc\":").append(senderAvailQuota.getF0()).append(",\"aPs\":").append(senderAvailQuota.getF1()).append("},\"c\":{\"aC\":").append(this.sender.getConfigure().getAliveConnections()).append(",\"gBf\":").append(this.sender.isGenByFactory()).append(",\"ifCc\":").append(this.sender.getFactoryPkgCntPermits()).append(",\"ifCs\":").append(this.sender.getFactoryPkgSizeKbPermits()).append(",\"iCc\":").append(this.sender.getConfigure().getMaxInFlightReqCnt()).append(",\"iCs\":").append(this.sender.getConfigure().getMaxInFlightSizeKb()).append(",\"iRp\":").append(this.sender.getConfigure().getPaddingSize()).append(",\"rP\":\"").append(this.sender.getConfigure().getDataRptProtocol()).append("\",\"rG\":\"").append(this.sender.getConfigure().getRegionName()).append("\"");
        if (this.sender instanceof TcpMsgSender) {
            TcpMsgSenderConfig tcpConfig = (TcpMsgSenderConfig)this.sender.getConfigure();
            strBuff.append(",\"mT\":").append(tcpConfig.getSdkMsgType().getValue()).append(",\"cp\":").append(tcpConfig.isEnableDataCompress()).append(",\"mCp\":").append(tcpConfig.getMinCompEnableLength()).append(",\"lf\":").append(tcpConfig.isSeparateEventByLF()).append(",\"nWk\":").append(tcpConfig.getNettyWorkerThreadNum()).append(",\"sB\":").append(tcpConfig.getSendBufferSize()).append(",\"rB\":").append(tcpConfig.getRcvBufferSize()).append(",\"cOt\":").append(tcpConfig.getConnectTimeoutMs()).append(",\"rOt\":").append(tcpConfig.getRequestTimeoutMs()).append(",\"syOt\":").append(tcpConfig.getMaxAllowedSyncMsgTimeoutCnt());
        } else {
            HttpMsgSenderConfig httpConfig = (HttpMsgSenderConfig)this.sender.getConfigure();
            strBuff.append(",\"iHs\":").append(httpConfig.isRptDataByHttps()).append(",\"sOt\":").append(httpConfig.getHttpSocketTimeoutMs()).append(",\"cOt\":").append(httpConfig.getHttpConTimeoutMs()).append(",\"aWk\":").append(httpConfig.getHttpAsyncRptWorkerNum());
        }
        String content = strBuff.append("}}").toString();
        strBuff.delete(0, strBuff.length());
        return content;
    }

    private static class MetricInfoUnit {
        protected final AtomicLong refCnt = new AtomicLong();
        protected final MetaSyncInfo metaSyncInfo = new MetaSyncInfo();
        protected final ConcurrentHashMap<String, TrafficInfo> trafficMap = new ConcurrentHashMap();
        protected final ConcurrentHashMap<Integer, LongAdder> errCodeMap = new ConcurrentHashMap();

        private MetricInfoUnit() {
        }

        public void addSyncSendSucInfo(String groupId, String streamId, int msgCnt, long costMs) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addSyncSucMsgInfo(msgCnt, costMs);
        }

        public void addSyncSendFailInfo(String groupId, String streamId, int msgCnt, int errCode) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addSyncFailMsgInfo(msgCnt);
            this.addSendErrCodeInfo(errCode);
        }

        public void addAsyncSendSucInfo(String groupId, String streamId, int msgCnt) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addAsyncSucSendInfo(msgCnt);
        }

        public void addAsyncSendFailInfo(String groupId, String streamId, int msgCnt, int errCode) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addAsyncFailSendInfo(msgCnt);
            this.addSendErrCodeInfo(errCode);
        }

        public void addAsyncHttpPutSucInfo(String groupId, String streamId, int msgCnt) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addAsyncHttpSucPutInfo(msgCnt);
        }

        public void addAsyncHttpPutFailInfo(String groupId, String streamId, int msgCnt, int errCode) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addAsyncHttpFailPutInfo(msgCnt);
            this.addSendErrCodeInfo(errCode);
        }

        public void addAsyncHttpGetSucInfo(String groupId, String streamId, int msgCnt) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addAsyncHttpSucGetInfo(msgCnt);
        }

        public void addAsyncRspSucInfo(String groupId, String streamId, int msgCnt, long sdCostMs, long cbCostMs) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addAsyncSucRspInfo(msgCnt, sdCostMs, cbCostMs);
        }

        public void addAsyncRspFailInfo(String groupId, String streamId, int msgCnt, int errCode, long cbCostMs) {
            TrafficInfo tmpInfo;
            String recordKey = this.getKeyStringByConfig(groupId, streamId);
            TrafficInfo trafficInfo = this.trafficMap.get(recordKey);
            if (trafficInfo == null && (trafficInfo = this.trafficMap.putIfAbsent(recordKey, tmpInfo = new TrafficInfo(groupId, streamId))) == null) {
                trafficInfo = tmpInfo;
            }
            trafficInfo.addAsyncFailRspInfo(msgCnt, cbCostMs);
            this.addSendErrCodeInfo(errCode);
        }

        private void addSendErrCodeInfo(int errCode) {
            LongAdder longCount = this.errCodeMap.get(errCode);
            if (longCount == null) {
                LongAdder tmpCount = new LongAdder();
                longCount = this.errCodeMap.putIfAbsent(errCode, tmpCount);
                if (longCount == null) {
                    longCount = tmpCount;
                }
            }
            longCount.increment();
        }

        public void getAndResetValue(StringBuilder strBuff) {
            int count = 0;
            this.metaSyncInfo.getAndResetValue(strBuff);
            strBuff.append(",\"tr\":[");
            for (Map.Entry<String, TrafficInfo> entry : this.trafficMap.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                if (count++ > 0) {
                    strBuff.append(",");
                }
                entry.getValue().getAndResetValue(strBuff);
            }
            strBuff.append("],\"errs\":{");
            count = 0;
            for (Map.Entry<Object, Object> entry : this.errCodeMap.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                if (count++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"e").append(entry.getKey()).append("\":").append(((LongAdder)entry.getValue()).sumThenReset());
            }
            strBuff.append("},");
            this.metaSyncInfo.getAndResetValue(strBuff);
            this.trafficMap.clear();
            this.errCodeMap.clear();
        }

        private String getKeyStringByConfig(String groupId, String streamId) {
            return groupId + MetricDataHolder.DEFAULT_KEY_SPLITTER + streamId + MetricDataHolder.DEFAULT_KEY_SPLITTER;
        }
    }
}

