/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class GenericRowData
implements RowData {
    private final Object[] fields;
    private RowKind kind;

    public GenericRowData(RowKind kind, int arity) {
        this.fields = new Object[arity];
        this.kind = kind;
    }

    public GenericRowData(int arity) {
        this.fields = new Object[arity];
        this.kind = RowKind.INSERT;
    }

    public void setField(int pos, Object value) {
        this.fields[pos] = value;
    }

    public Object getField(int pos) {
        return this.fields[pos];
    }

    @Override
    public int getArity() {
        return this.fields.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.kind;
    }

    @Override
    public void setRowKind(RowKind kind) {
        Preconditions.checkNotNull((Object)kind);
        this.kind = kind;
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.fields[pos] == null;
    }

    @Override
    public boolean getBoolean(int pos) {
        return (Boolean)this.fields[pos];
    }

    @Override
    public byte getByte(int pos) {
        return (Byte)this.fields[pos];
    }

    @Override
    public short getShort(int pos) {
        return (Short)this.fields[pos];
    }

    @Override
    public int getInt(int pos) {
        return (Integer)this.fields[pos];
    }

    @Override
    public long getLong(int pos) {
        return (Long)this.fields[pos];
    }

    @Override
    public float getFloat(int pos) {
        return ((Float)this.fields[pos]).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return (Double)this.fields[pos];
    }

    @Override
    public StringData getString(int pos) {
        return (StringData)this.fields[pos];
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return (DecimalData)this.fields[pos];
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return (TimestampData)this.fields[pos];
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        return (RawValueData)this.fields[pos];
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.fields[pos];
    }

    @Override
    public ArrayData getArray(int pos) {
        return (ArrayData)this.fields[pos];
    }

    @Override
    public MapData getMap(int pos) {
        return (MapData)this.fields[pos];
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return (RowData)this.fields[pos];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericRowData)) {
            return false;
        }
        GenericRowData that = (GenericRowData)o;
        return this.kind == that.kind && Arrays.deepEquals(this.fields, that.fields);
    }

    public int hashCode() {
        int result = Objects.hash(this.kind);
        result = 31 * result + Arrays.deepHashCode(this.fields);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.kind.shortString()).append("(");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(StringUtils.arrayAwareToString((Object)this.fields[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    public static GenericRowData of(Object ... values) {
        GenericRowData row = new GenericRowData(values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    public static GenericRowData ofKind(RowKind kind, Object ... values) {
        GenericRowData row = new GenericRowData(kind, values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }
}

