/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Fun;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.SerializerPojo;
import org.mapdb.Store;
import org.mapdb.TxRollbackException;

public class TxEngine
extends EngineWrapper {
    protected static final Object TOMBSTONE = new Object();
    protected final ReentrantReadWriteLock commitLock = new ReentrantReadWriteLock(false);
    protected final ReentrantReadWriteLock[] locks = new ReentrantReadWriteLock[128];
    protected volatile boolean uncommitedData;
    protected Set<Reference<Tx>> txs;
    protected ReferenceQueue<Tx> txQueue;
    protected final boolean fullTx;
    protected final Queue<Long> preallocRecids;
    protected final int PREALLOC_RECID_SIZE = 128;

    protected TxEngine(Engine engine, boolean fullTx) {
        super(engine);
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantReadWriteLock(false);
        }
        this.uncommitedData = false;
        this.txs = new LinkedHashSet<Reference<Tx>>();
        this.txQueue = new ReferenceQueue();
        this.PREALLOC_RECID_SIZE = 128;
        this.fullTx = fullTx;
        this.preallocRecids = fullTx ? new ArrayBlockingQueue(128) : null;
    }

    protected Long preallocRecidTake() {
        assert (this.commitLock.isWriteLockedByCurrentThread());
        Long recid = this.preallocRecids.poll();
        if (recid != null) {
            return recid;
        }
        if (this.uncommitedData) {
            throw new IllegalAccessError("uncommited data");
        }
        for (int i = 0; i < 128; ++i) {
            this.preallocRecids.add(super.preallocate());
        }
        recid = super.preallocate();
        super.commit();
        this.uncommitedData = false;
        return recid;
    }

    public static Engine createSnapshotFor(Engine engine) {
        if (engine.isReadOnly()) {
            return engine;
        }
        if (engine instanceof TxEngine) {
            return ((TxEngine)engine).snapshot();
        }
        if (engine instanceof EngineWrapper) {
            TxEngine.createSnapshotFor(((EngineWrapper)engine).getWrappedEngine());
        }
        throw new UnsupportedOperationException("Snapshots are not enabled, use DBMaker.snapshotEnable()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Engine snapshot() {
        this.commitLock.writeLock().lock();
        try {
            this.cleanTxQueue();
            if (this.uncommitedData && this.canRollback()) {
                throw new IllegalAccessError("Can not create snapshot with uncommited data");
            }
            Tx tx = new Tx();
            return tx;
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    protected void cleanTxQueue() {
        assert (this.commitLock.writeLock().isHeldByCurrentThread());
        Reference<Tx> ref = this.txQueue.poll();
        while (ref != null) {
            this.txs.remove(ref);
            ref = this.txQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        this.commitLock.writeLock().lock();
        try {
            this.uncommitedData = true;
            long recid = super.preallocate();
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
            lock.lock();
            try {
                for (Reference<Tx> txr : this.txs) {
                    Tx tx = txr.get();
                    if (tx == null) continue;
                    tx.old.putIfAbsent(recid, TOMBSTONE);
                }
            }
            finally {
                lock.unlock();
            }
            long l = recid;
            return l;
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preallocate(long[] recids) {
        this.commitLock.writeLock().lock();
        try {
            this.uncommitedData = true;
            super.preallocate(recids);
            for (long recid : recids) {
                ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
                lock.lock();
                try {
                    for (Reference<Tx> txr : this.txs) {
                        Tx tx = txr.get();
                        if (tx == null) continue;
                        tx.old.putIfAbsent(recid, TOMBSTONE);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.uncommitedData = true;
            long recid = super.put(value, serializer);
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
            lock.lock();
            try {
                for (Reference<Tx> txr : this.txs) {
                    Tx tx = txr.get();
                    if (tx == null) continue;
                    tx.old.putIfAbsent(recid, TOMBSTONE);
                }
            }
            finally {
                lock.unlock();
            }
            long l = recid;
            return l;
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            A a = super.get(recid, serializer);
            return a;
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.uncommitedData = true;
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
            lock.lock();
            try {
                A old = this.get(recid, serializer);
                for (Reference<Tx> txr : this.txs) {
                    Tx tx = txr.get();
                    if (tx == null) continue;
                    tx.old.putIfAbsent(recid, old);
                }
                super.update(recid, value, serializer);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.uncommitedData = true;
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
            lock.lock();
            try {
                boolean ret = super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
                if (ret) {
                    for (Reference<Tx> txr : this.txs) {
                        Tx tx = txr.get();
                        if (tx == null) continue;
                        tx.old.putIfAbsent(recid, expectedOldValue);
                    }
                }
                boolean bl = ret;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                lock.unlock();
                throw throwable;
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.uncommitedData = true;
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
            lock.lock();
            try {
                A old = this.get(recid, serializer);
                for (Reference<Tx> txr : this.txs) {
                    Tx tx = txr.get();
                    if (tx == null) continue;
                    tx.old.putIfAbsent(recid, old);
                }
                super.delete(recid, serializer);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.commitLock.writeLock().lock();
        try {
            super.close();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.commitLock.writeLock().lock();
        try {
            this.cleanTxQueue();
            super.commit();
            this.uncommitedData = false;
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        this.commitLock.writeLock().lock();
        try {
            this.cleanTxQueue();
            super.rollback();
            this.uncommitedData = false;
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    protected void superCommit() {
        assert (this.commitLock.isWriteLockedByCurrentThread());
        super.commit();
    }

    protected <A> void superUpdate(long recid, A value, Serializer<A> serializer) {
        assert (this.commitLock.isWriteLockedByCurrentThread());
        super.update(recid, value, serializer);
    }

    protected <A> void superDelete(long recid, Serializer<A> serializer) {
        assert (this.commitLock.isWriteLockedByCurrentThread());
        super.delete(recid, serializer);
    }

    protected <A> A superGet(long recid, Serializer<A> serializer) {
        assert (this.commitLock.isWriteLockedByCurrentThread());
        return super.get(recid, serializer);
    }

    public class Tx
    implements Engine {
        protected LongConcurrentHashMap old = new LongConcurrentHashMap();
        protected LongConcurrentHashMap<Fun.Tuple2> mod;
        protected Collection<Long> usedPreallocatedRecids;
        protected final Reference<Tx> ref;
        protected boolean closed;
        private Store parentEngine;
        SerializerPojo pojo;

        public Tx() {
            this.mod = TxEngine.this.fullTx ? new LongConcurrentHashMap() : null;
            this.usedPreallocatedRecids = TxEngine.this.fullTx ? new ArrayList() : null;
            this.ref = new WeakReference<Tx>(this, TxEngine.this.txQueue);
            this.closed = false;
            this.pojo = new SerializerPojo((CopyOnWriteArrayList)TxEngine.this.getSerializerPojo().registered.clone());
            assert (TxEngine.this.commitLock.isWriteLockedByCurrentThread());
            TxEngine.this.txs.add(this.ref);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long preallocate() {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                Long recid = TxEngine.this.preallocRecidTake();
                this.usedPreallocatedRecids.add(recid);
                long l = recid;
                return l;
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preallocate(long[] recids) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                for (int i = 0; i < recids.length; ++i) {
                    Long recid = TxEngine.this.preallocRecidTake();
                    this.usedPreallocatedRecids.add(recid);
                    recids[i] = recid;
                }
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                Long recid = TxEngine.this.preallocRecidTake();
                this.usedPreallocatedRecids.add(recid);
                this.mod.put(recid, Fun.t2(value, serializer));
                long l = recid;
                return l;
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            TxEngine.this.commitLock.readLock().lock();
            try {
                A a;
                if (this.closed) {
                    throw new IllegalAccessError("closed");
                }
                ReentrantReadWriteLock.ReadLock lock = TxEngine.this.locks[Store.lockPos(recid)].readLock();
                lock.lock();
                try {
                    a = this.getNoLock(recid, serializer);
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
                return a;
            }
            finally {
                TxEngine.this.commitLock.readLock().unlock();
            }
        }

        private <A> A getNoLock(long recid, Serializer<A> serializer) {
            Fun.Tuple2 tu;
            if (TxEngine.this.fullTx && (tu = this.mod.get(recid)) != null) {
                if (tu.a == TOMBSTONE) {
                    return null;
                }
                return tu.a;
            }
            Object oldVal = this.old.get(recid);
            if (oldVal != null) {
                if (oldVal == TOMBSTONE) {
                    return null;
                }
                return (A)oldVal;
            }
            return TxEngine.this.get(recid, serializer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.readLock().lock();
            try {
                this.mod.put(recid, Fun.t2(value, serializer));
            }
            finally {
                TxEngine.this.commitLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.readLock().lock();
            try {
                ReentrantReadWriteLock.WriteLock lock = TxEngine.this.locks[Store.lockPos(recid)].writeLock();
                lock.lock();
                try {
                    boolean ret;
                    A oldVal = this.getNoLock(recid, serializer);
                    boolean bl = ret = oldVal != null && oldVal.equals(expectedOldValue);
                    if (ret) {
                        this.mod.put(recid, Fun.t2(newValue, serializer));
                    }
                    boolean bl2 = ret;
                    lock.unlock();
                    return bl2;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            finally {
                TxEngine.this.commitLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.readLock().lock();
            try {
                this.mod.put(recid, Fun.t2(TOMBSTONE, serializer));
            }
            finally {
                TxEngine.this.commitLock.readLock().unlock();
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.old.clear();
            this.ref.clear();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                long recid;
                if (this.closed) {
                    return;
                }
                if (TxEngine.this.uncommitedData) {
                    throw new IllegalAccessError("uncomitted data");
                }
                TxEngine.this.txs.remove(this.ref);
                TxEngine.this.cleanTxQueue();
                if (this.pojo.hasUnsavedChanges()) {
                    this.pojo.save(this);
                }
                LongMap.LongMapIterator oldIter = this.old.longMapIterator();
                while (oldIter.moveToNext()) {
                    long recid2 = oldIter.key();
                    for (Reference<Tx> ref2 : TxEngine.this.txs) {
                        Tx tx = ref2.get();
                        if (tx == this || tx == null || !tx.mod.containsKey(recid2)) continue;
                        this.close();
                        throw new TxRollbackException();
                    }
                }
                LongMap.LongMapIterator<Fun.Tuple2> iter = this.mod.longMapIterator();
                while (iter.moveToNext()) {
                    recid = iter.key();
                    if (!this.old.containsKey(recid)) continue;
                    this.close();
                    throw new TxRollbackException();
                }
                iter = this.mod.longMapIterator();
                while (iter.moveToNext()) {
                    recid = iter.key();
                    Fun.Tuple2 val = iter.value();
                    Serializer ser = (Serializer)val.b;
                    Object old = TxEngine.this.superGet(recid, ser);
                    if (old == null) {
                        old = TOMBSTONE;
                    }
                    for (Reference<Tx> txr : TxEngine.this.txs) {
                        Tx tx = txr.get();
                        if (tx == null || tx == this) continue;
                        tx.old.putIfAbsent(recid, old);
                    }
                    if (val.a == TOMBSTONE) {
                        TxEngine.this.superDelete(recid, ser);
                        continue;
                    }
                    TxEngine.this.superUpdate(recid, val.a, ser);
                }
                this.getWrappedEngine().getSerializerPojo().registered = this.pojo.registered;
                TxEngine.this.superCommit();
                this.close();
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() throws UnsupportedOperationException {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                if (this.closed) {
                    return;
                }
                if (TxEngine.this.uncommitedData) {
                    throw new IllegalAccessError("uncomitted data");
                }
                TxEngine.this.txs.remove(this.ref);
                TxEngine.this.cleanTxQueue();
                for (Long prealloc : this.usedPreallocatedRecids) {
                    TxEngine.this.superDelete(prealloc, null);
                }
                TxEngine.this.superCommit();
                this.close();
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        @Override
        public boolean isReadOnly() {
            return !TxEngine.this.fullTx;
        }

        @Override
        public boolean canRollback() {
            return TxEngine.this.fullTx;
        }

        @Override
        public void clearCache() {
        }

        @Override
        public void compact() {
        }

        @Override
        public SerializerPojo getSerializerPojo() {
            return this.pojo;
        }

        public Engine getWrappedEngine() {
            return TxEngine.this.getWrappedEngine();
        }
    }
}

