/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@Scope(value=Scopes.NAMED_CACHE)
public class ClusterExpirationManager<K, V>
extends ExpirationManagerImpl<K, V> {
    private static final Log log = LogFactory.getLog(ClusterExpirationManager.class);
    private static final int MAX_CONCURRENT_EXPIRATIONS = 100;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected DistributionManager distributionManager;
    private Address localAddress;
    private long timeout;

    @Override
    public void start() {
        super.start();
        this.localAddress = this.cache.getCacheManager().getAddress();
        this.timeout = this.configuration.clustering().remoteTimeout();
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener((a, ignored) -> {
            this.timeout = (Long)a.get();
        });
    }

    @Override
    public void processExpiration() {
        if (!Thread.currentThread().isInterrupted()) {
            LocalizedCacheTopology topology;
            while (this.purgeInMemoryContents(topology = this.distributionManager.getCacheTopology())) {
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            CompletionStages.join(this.persistenceManager.purgeExpired());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean purgeInMemoryContents(LocalizedCacheTopology topology) {
        long start = 0L;
        int removedEntries = 0;
        AtomicInteger errors = new AtomicInteger();
        try {
            if (log.isTraceEnabled()) {
                log.tracef("Purging data container on cache %s for topology %d", this.cacheName, topology.getTopologyId());
                start = this.timeService.time();
            }
            ArrayBlockingQueue expirationPermits = new ArrayBlockingQueue(100);
            long currentTimeMillis = this.timeService.wallClockTime();
            IntSet segments = topology.getReadConsistentHash().getMembers().contains(this.localAddress) ? IntSets.from(topology.getReadConsistentHash().getPrimarySegmentsForOwner(this.localAddress)) : IntSets.immutableEmptySet();
            Iterator purgeCandidates = ((InternalDataContainer)this.dataContainer.running()).iteratorIncludingExpired(segments);
            while (purgeCandidates.hasNext()) {
                InternalCacheEntry ice = purgeCandidates.next();
                if (ice.canExpire()) {
                    boolean expiredTransient;
                    boolean expiredMortal;
                    long lifespan;
                    Object value;
                    InternalCacheEntry internalCacheEntry = ice;
                    synchronized (internalCacheEntry) {
                        value = ice.getValue();
                        lifespan = ice.getLifespan();
                        long maxIdle = ice.getMaxIdle();
                        expiredMortal = ExpiryHelper.isExpiredMortal(lifespan, ice.getCreated(), currentTimeMillis);
                        expiredTransient = ExpiryHelper.isExpiredTransient(maxIdle, ice.getLastUsed(), currentTimeMillis);
                    }
                    if (expiredMortal || expiredTransient) {
                        if (++removedEntries > 100 && !this.pollForCompletion(expirationPermits, start, removedEntries, errors)) {
                            return false;
                        }
                        CompletableFuture<Boolean> stage = expiredMortal ? this.handleLifespanExpireEntry(ice.getKey(), value, lifespan, false) : this.handleMaxIdleExpireEntry(ice, false, currentTimeMillis);
                        stage.whenComplete((obj, t) -> this.addStageToPermits(expirationPermits, stage));
                    }
                }
                if (this.distributionManager.getCacheTopology() == topology) continue;
                this.printResults("Purging data container on cache %s stopped due to topology change. Total time was: %s and removed %d entries with %d errors", start, removedEntries, errors);
                return true;
            }
            int expirationsLeft = Math.min(removedEntries, 100);
            for (int i = 0; i < expirationsLeft; ++i) {
                if (this.pollForCompletion(expirationPermits, start, removedEntries, errors)) continue;
                return false;
            }
            this.printResults("Purging data container on cache %s completed in %s and removed %d entries with %d errors", start, removedEntries, errors);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.printResults("Purging data container on cache %s was interrupted. Total time was: %s and removed %d entries with %d errors", start, removedEntries, errors);
        }
        catch (Throwable t2) {
            log.exceptionPurgingDataContainer(t2);
        }
        return false;
    }

    void addStageToPermits(BlockingQueue<CompletableFuture<?>> expirationPermits, CompletableFuture<?> future) {
        boolean inserted = expirationPermits.offer(future);
        assert (inserted);
    }

    private void printResults(String message, long start, int removedEntries, AtomicInteger errors) {
        if (log.isTraceEnabled()) {
            log.tracef(message, new Object[]{this.cacheName, Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)), removedEntries, errors.get()});
        }
    }

    private boolean pollForCompletion(BlockingQueue<CompletableFuture<?>> queue, long start, int removedEntries, AtomicInteger errors) throws InterruptedException, TimeoutException {
        CompletableFuture<?> future = queue.poll(this.timeout * 3L, TimeUnit.MILLISECONDS);
        if (future != null) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                errors.incrementAndGet();
                log.exceptionPurgingDataContainer(e.getCause());
            }
            return true;
        }
        this.printResults("Purging data container on cache %s stopped due to waiting for prior removal (could be a bug or misconfiguration). Total time was: %s and removed %d entries", start, removedEntries, errors);
        return false;
    }

    CompletableFuture<Boolean> handleLifespanExpireEntry(K key, V value, long lifespan, boolean isWrite) {
        return this.handleEitherExpiration(key, value, false, lifespan, isWrite);
    }

    CompletableFuture<Boolean> removeLifespan(AdvancedCache<K, V> cacheToUse, K key, V value, long lifespan) {
        return cacheToUse.removeLifespanExpired(key, value, lifespan);
    }

    CompletableFuture<Boolean> handleMaxIdleExpireEntry(InternalCacheEntry<K, V> entry, boolean isWrite, long currentTime) {
        return this.handleEitherExpiration(entry.getKey(), entry.getValue(), true, entry.getMaxIdle(), isWrite).thenCompose(expired -> {
            if (!expired.booleanValue()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Entry was not actually expired via max idle - touching on all nodes", new Object[0]);
                }
                return this.checkExpiredMaxIdle(entry, this.keyPartitioner.getSegment(entry.getKey()), currentTime).thenApply(ignore -> Boolean.FALSE);
            }
            return CompletableFutures.completedTrue();
        });
    }

    CompletableFuture<Boolean> removeMaxIdle(AdvancedCache<K, V> cacheToUse, K key, V value) {
        return cacheToUse.removeMaxIdleExpired(key, value);
    }

    private CompletableFuture<Boolean> handleEitherExpiration(K key, V value, boolean maxIdle, long time, boolean isWrite) {
        CompletableFuture completableFuture = new CompletableFuture();
        CompletableFuture<Boolean> previousFuture = this.expiring.putIfAbsent(key, completableFuture);
        if (previousFuture == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Submitting expiration removal for key: %s which is maxIdle: %s of: %s", Util.toStr(key), maxIdle, time);
            }
            try {
                AdvancedCache<K, V> cacheToUse = this.cacheToUse(isWrite);
                CompletableFuture<Boolean> future = maxIdle ? this.removeMaxIdle(cacheToUse, key, value) : this.removeLifespan(cacheToUse, key, value, time);
                return future.whenComplete((b, t) -> {
                    this.expiring.remove(key);
                    if (t != null) {
                        completableFuture.completeExceptionally((Throwable)t);
                    } else {
                        completableFuture.complete(b);
                    }
                });
            }
            catch (Throwable t2) {
                this.expiring.remove(key);
                completableFuture.completeExceptionally(t2);
                throw t2;
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("There is a pending expiration removal for key %s, waiting until it completes.", key);
        }
        return previousFuture;
    }

    Throwable getMostNestedSuppressedThrowable(Throwable t) {
        Throwable nested = this.getNestedThrowable(t);
        Throwable[] suppressedNested = nested.getSuppressed();
        if (suppressedNested.length > 0) {
            nested = this.getNestedThrowable(suppressedNested[0]);
        }
        return nested;
    }

    Throwable getNestedThrowable(Throwable t) {
        Throwable cause;
        while ((cause = t.getCause()) != null) {
            t = cause;
        }
        return t;
    }

    AdvancedCache<K, V> cacheToUse(boolean isWrite) {
        return isWrite ? this.cache.withFlags(Flag.SKIP_LOCKING) : this.cache.withFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> entryExpiredInMemory(InternalCacheEntry<K, V> entry, long currentTime, boolean isWrite) {
        CompletableFuture<Boolean> future;
        boolean expiredMortal;
        long lifespan;
        Object value;
        InternalCacheEntry<K, V> internalCacheEntry = entry;
        synchronized (internalCacheEntry) {
            value = entry.getValue();
            lifespan = entry.getLifespan();
            expiredMortal = ExpiryHelper.isExpiredMortal(lifespan, entry.getCreated(), currentTime);
        }
        if (expiredMortal) {
            future = this.handleLifespanExpireEntry(entry.getKey(), value, lifespan, isWrite);
            if (!this.waitOnLifespanExpiration(isWrite)) {
                return CompletableFutures.completedTrue();
            }
        } else {
            future = this.handleMaxIdleExpireEntry(entry, isWrite, currentTime);
        }
        return ((CompletableFuture)future.handle((expired, t) -> {
            if (t != null) {
                Throwable cause = this.getMostNestedSuppressedThrowable((Throwable)t);
                if (cause instanceof org.infinispan.util.concurrent.TimeoutException) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Encountered timeout exception in remove expired invocation - need to retry!", new Object[0]);
                    }
                    return this.entryExpiredInMemory(entry, currentTime, isWrite);
                }
                if (log.isTraceEnabled()) {
                    log.tracef((Throwable)t, "Encountered exception in remove expired invocation - propagating!", new Object[0]);
                }
                return CompletableFutures.completedExceptionFuture(cause);
            }
            return expired == Boolean.TRUE ? CompletableFutures.completedTrue() : CompletableFutures.completedFalse();
        })).thenCompose(Function.identity());
    }

    boolean waitOnLifespanExpiration(boolean isWrite) {
        return isWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean entryExpiredInMemoryFromIteration(InternalCacheEntry<K, V> entry, long currentTime) {
        boolean expiredMortal;
        InternalCacheEntry<K, V> internalCacheEntry = entry;
        synchronized (internalCacheEntry) {
            expiredMortal = ExpiryHelper.isExpiredMortal(entry.getLifespan(), entry.getCreated(), currentTime);
        }
        return expiredMortal;
    }

    @Override
    public CompletionStage<Void> handleInStoreExpirationInternal(K key) {
        return this.handleInStoreExpirationInternal(key, null);
    }

    @Override
    public CompletionStage<Void> handleInStoreExpirationInternal(MarshallableEntry<K, V> marshalledEntry) {
        return this.handleInStoreExpirationInternal(marshalledEntry.getKey(), marshalledEntry);
    }

    private CompletionStage<Void> handleInStoreExpirationInternal(K key, MarshallableEntry<K, V> marshallableEntry) {
        CompletableFuture completableFuture = new CompletableFuture();
        CompletableFuture previousFuture = this.expiring.putIfAbsent(key, completableFuture);
        if (previousFuture == null) {
            CompletableFuture<Boolean> resultStage;
            AdvancedCache<K, V> cacheToUse = this.cache.withFlags(Flag.SKIP_SHARED_CACHE_STORE, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
            if (marshallableEntry != null) {
                Metadata metadata = marshallableEntry.getMetadata();
                resultStage = cacheToUse.removeLifespanExpired(key, marshallableEntry.getValue(), metadata == null || metadata.lifespan() == -1L ? null : Long.valueOf(metadata.lifespan()));
            } else {
                resultStage = cacheToUse.removeLifespanExpired(key, null, null);
            }
            return CompletionStages.ignoreValue(resultStage.whenComplete((b, t) -> {
                this.expiring.remove(key);
                if (t != null) {
                    completableFuture.completeExceptionally((Throwable)t);
                } else {
                    completableFuture.complete(b);
                }
            }));
        }
        return CompletionStages.ignoreValue(previousFuture);
    }

    @Override
    protected CompletionStage<Boolean> checkExpiredMaxIdle(InternalCacheEntry ice, int segment, long currentTime) {
        return this.attemptTouchAndReturnIfExpired(ice, segment, currentTime).handle((expired, t) -> {
            if (t != null) {
                Throwable innerT = CompletableFutures.extractException(t);
                if (innerT instanceof OutdatedTopologyException) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Touch received OutdatedTopologyException, retrying", new Object[0]);
                    }
                    return this.attemptTouchAndReturnIfExpired(ice, segment, currentTime);
                }
                return CompletableFutures.completedExceptionFuture(t);
            }
            return CompletableFuture.completedFuture(expired);
        }).thenCompose(Function.identity());
    }

    private CompletionStage<Boolean> attemptTouchAndReturnIfExpired(InternalCacheEntry ice, int segment, long currentTime) {
        return this.cache.touch(ice.getKey(), segment, true).thenApply(touched -> {
            if (touched.booleanValue()) {
                ice.touch(currentTime);
            }
            return touched == false;
        });
    }
}

