/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.encryption;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="encryption", names={"sha"}, parameter="(String str)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return a string of 40 hexadecimal digits (the SHA-1 160 bit)."}, examples={"sha(\"5\") = \"ac3478d69a3c81fa62e60f5c3696165a4e5e6ac4\""})
public class ShaFunction
implements ValueParser {
    private final ValueParser msgParser;

    public ShaFunction(Function expr) {
        this.msgParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object msgObj = this.msgParser.parse(sourceData, rowIndex, context);
        if (msgObj == null) {
            return null;
        }
        return DigestUtils.sha1Hex((byte[])OperatorTools.parseBytes(msgObj));
    }
}

