/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"parse_url"}, parameter="(String urlStr, String keyword[, String parameter])", descriptions={"- Return NULL any required parameter is NULL;", "- Return the specified part from the 'urlStr'. Valid values for 'keyword'.", "Note: The 'keyword' is one of ('HOST', 'PATH', 'QUERY', 'REF', 'PROTOCOL', 'AUTHORITY', 'FILE', 'USERINFO'). Also a value of a particular key in QUERY can be extracted by providing the key as the third argument."}, examples={"parse_url('http://inlong.apache.org/p.php?k1=v1&k2=v2#Ref1', 'QUERY', 'k1') = v1", "parse_url('http://inlong.apache.org/p.php?k1=v1&k2=v2#Ref1', 'PROTOCOL') = http"})
public class ParseUrlFunction
implements ValueParser {
    private ValueParser urlParser;
    private ValueParser partParser;
    private ValueParser keyParser;
    private final String exprKey;

    public ParseUrlFunction(Function expr) {
        List params = expr.getParameters().getExpressions();
        this.urlParser = OperatorTools.buildParser((Expression)params.get(0));
        this.partParser = params.size() > 1 ? OperatorTools.buildParser((Expression)params.get(1)) : null;
        this.keyParser = params.size() > 2 ? OperatorTools.buildParser((Expression)params.get(2)) : null;
        this.exprKey = expr.toString();
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        String key;
        Object keyObj;
        Map<String, Object> runtimeParams = context.getRuntimeParams();
        if (runtimeParams.containsKey(this.exprKey)) {
            return runtimeParams.get(this.exprKey);
        }
        if (this.urlParser == null || this.partParser == null) {
            runtimeParams.put(this.exprKey, null);
            return null;
        }
        Object urlObj = this.urlParser.parse(sourceData, rowIndex, context);
        Object partObj = this.partParser.parse(sourceData, rowIndex, context);
        Object object = keyObj = this.keyParser != null ? this.keyParser.parse(sourceData, rowIndex, context) : null;
        if (urlObj == null || partObj == null) {
            runtimeParams.put(this.exprKey, null);
            return null;
        }
        String url = OperatorTools.parseString(urlObj);
        String part = OperatorTools.parseString(partObj);
        String string = key = keyObj != null ? OperatorTools.parseString(keyObj) : null;
        if (this.keyParser != null && key == null) {
            runtimeParams.put(this.exprKey, null);
            return null;
        }
        if ("QUERY".equals(part)) {
            String strQuery = null;
            try {
                URL netUrl = new URL(url);
                strQuery = netUrl.getQuery();
            }
            catch (MalformedURLException e) {
                strQuery = url;
            }
            Map<String, String> queryPairs = this.splitQuery(strQuery);
            if (key == null) {
                runtimeParams.put(this.exprKey, strQuery);
                return strQuery;
            }
            return queryPairs.getOrDefault(key, "");
        }
        try {
            URL netUrl = new URL(url);
            switch (part) {
                case "HOST": {
                    String exprValue = netUrl.getHost();
                    runtimeParams.put(this.exprKey, exprValue);
                    return exprValue;
                }
                case "PATH": {
                    String exprValue = netUrl.getPath();
                    runtimeParams.put(this.exprKey, exprValue);
                    return exprValue;
                }
                case "REF": {
                    String exprValue = netUrl.getRef();
                    runtimeParams.put(this.exprKey, exprValue);
                    return exprValue;
                }
                case "PROTOCOL": {
                    String exprValue = netUrl.getProtocol();
                    runtimeParams.put(this.exprKey, exprValue);
                    return exprValue;
                }
                case "AUTHORITY": {
                    String exprValue = netUrl.getAuthority();
                    runtimeParams.put(this.exprKey, exprValue);
                    return exprValue;
                }
                case "FILE": {
                    String exprValue = netUrl.getFile();
                    runtimeParams.put(this.exprKey, exprValue);
                    return exprValue;
                }
                case "USERINFO": {
                    String exprValue = netUrl.getUserInfo();
                    runtimeParams.put(this.exprKey, exprValue);
                    return exprValue;
                }
            }
            runtimeParams.put(this.exprKey, null);
            return null;
        }
        catch (MalformedURLException e) {
            runtimeParams.put(this.exprKey, null);
            return null;
        }
    }

    private Map<String, String> splitQuery(String query) {
        HashMap<String, String> queryPairs = new HashMap<String, String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                if (idx == -1) continue;
                queryPairs.put(this.manualDecode(pair.substring(0, idx)), this.manualDecode(pair.substring(idx + 1)));
            }
        }
        return queryPairs;
    }

    private String manualDecode(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i + 2 < s.length()) {
                    try {
                        int num = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        sb.append((char)num);
                        i += 2;
                    }
                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                        sb.append(c);
                    }
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

