/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.constant.OracleConstant;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="oracleExtract")
public class OracleExtractNode
extends ExtractNode
implements InlongMetric,
Metadata,
Serializable {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @Nonnull
    @JsonProperty(value="hostname")
    private String hostname;
    @Nonnull
    @JsonProperty(value="username")
    private String username;
    @Nonnull
    @JsonProperty(value="password")
    private String password;
    @Nonnull
    @JsonProperty(value="database")
    private String database;
    @Nonnull
    @JsonProperty(value="schemaName")
    private String schemaName;
    @Nonnull
    @JsonProperty(value="tableName")
    private String tableName;
    @JsonProperty(value="port", defaultValue="1521")
    private Integer port;
    @Nullable
    @JsonProperty(value="scanStartupMode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OracleConstant.ScanStartUpMode scanStartupMode;

    @JsonCreator
    public OracleExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermark_field") WatermarkField watermarkField, @JsonProperty(value="properties") Map<String, String> properties, @Nullable @JsonProperty(value="primaryKey") String primaryKey, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="database") String database, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="port", defaultValue="1521") Integer port, @Nullable @JsonProperty(value="scanStartupMode") OracleConstant.ScanStartUpMode scanStartupMode) {
        super(id, name, fields, watermarkField, properties);
        this.primaryKey = primaryKey;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname is null");
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username is null");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password is null");
        this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"database is null");
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName, (Object)"schemaName is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        this.port = port;
        this.scanStartupMode = scanStartupMode;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "oracle-cdc-inlong");
        options.put("hostname", this.hostname);
        options.put("username", this.username);
        options.put("password", this.password);
        options.put("database-name", this.database);
        options.put("schema-name", this.schemaName);
        options.put("table-name", this.tableName);
        if (!options.containsKey("debezium.database.tablename.case.insensitive")) {
            options.put("debezium.database.tablename.case.insensitive", "false");
        }
        if (!options.containsKey("debezium.log.mining.strategy")) {
            options.put("debezium.log.mining.strategy", "online_catalog");
        }
        if (!options.containsKey("debezium.log.mining.continuous.mine")) {
            options.put("debezium.log.mining.continuous.mine", "true");
        }
        if (this.port != null) {
            options.put("port", this.port.toString());
        }
        if (this.scanStartupMode != null) {
            options.put("scan.startup.mode", this.scanStartupMode.getValue());
        }
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("node_%s", super.getId());
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return true;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.PROCESS_TIME, new MetaField[]{MetaField.TABLE_NAME, MetaField.DATABASE_NAME, MetaField.SCHEMA_NAME, MetaField.OP_TS, MetaField.OP_TYPE, MetaField.DATA, MetaField.DATA_BYTES, MetaField.DATA_CANAL, MetaField.DATA_BYTES_CANAL, MetaField.IS_DDL, MetaField.TS, MetaField.SQL_TYPE, MetaField.ORACLE_TYPE, MetaField.PK_NAMES});
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case TABLE_NAME: {
                metadataKey = "meta.table_name";
                break;
            }
            case DATABASE_NAME: {
                metadataKey = "meta.database_name";
                break;
            }
            case SCHEMA_NAME: {
                metadataKey = "meta.schema_name";
                break;
            }
            case OP_TS: {
                metadataKey = "meta.op_ts";
                break;
            }
            case OP_TYPE: {
                metadataKey = "meta.op_type";
                break;
            }
            case DATA: 
            case DATA_BYTES: {
                metadataKey = "meta.data";
                break;
            }
            case DATA_CANAL: 
            case DATA_BYTES_CANAL: {
                metadataKey = "meta.data_canal";
                break;
            }
            case IS_DDL: {
                metadataKey = "meta.is_ddl";
                break;
            }
            case TS: {
                metadataKey = "meta.ts";
                break;
            }
            case SQL_TYPE: {
                metadataKey = "meta.sql_type";
                break;
            }
            case ORACLE_TYPE: {
                metadataKey = "meta.oracle_type";
                break;
            }
            case PK_NAMES: {
                metadataKey = "meta.pk_names";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", this.getClass().getSimpleName(), metaField));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OracleExtractNode)) {
            return false;
        }
        OracleExtractNode other = (OracleExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        OracleConstant.ScanStartUpMode this$scanStartupMode = this.getScanStartupMode();
        OracleConstant.ScanStartUpMode other$scanStartupMode = other.getScanStartupMode();
        return !(this$scanStartupMode == null ? other$scanStartupMode != null : !((Object)((Object)this$scanStartupMode)).equals((Object)other$scanStartupMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OracleExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        OracleConstant.ScanStartUpMode $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : ((Object)((Object)$scanStartupMode)).hashCode());
        return result;
    }

    @Override
    @Nullable
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Nonnull
    public String getHostname() {
        return this.hostname;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public String getDatabase() {
        return this.database;
    }

    @Nonnull
    public String getSchemaName() {
        return this.schemaName;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    public Integer getPort() {
        return this.port;
    }

    @Nullable
    public OracleConstant.ScanStartUpMode getScanStartupMode() {
        return this.scanStartupMode;
    }

    public void setPrimaryKey(@Nullable String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setHostname(@Nonnull String hostname) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        this.hostname = hostname;
    }

    public void setUsername(@Nonnull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.username = username;
    }

    public void setPassword(@Nonnull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.password = password;
    }

    public void setDatabase(@Nonnull String database) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        this.database = database;
    }

    public void setSchemaName(@Nonnull String schemaName) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        this.schemaName = schemaName;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setScanStartupMode(@Nullable OracleConstant.ScanStartUpMode scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    @Override
    public String toString() {
        return "OracleExtractNode(primaryKey=" + this.getPrimaryKey() + ", hostname=" + this.getHostname() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", port=" + this.getPort() + ", scanStartupMode=" + (Object)((Object)this.getScanStartupMode()) + ")";
    }
}

