/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.transformation.CascadeFunction;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;

@JsonTypeName(value="encrypt")
public class EncryptFunction
implements CascadeFunction,
Serializable {
    private static final long serialVersionUID = -2701547146694616429L;
    @JsonProperty(value="field")
    private FieldInfo field;
    @JsonProperty(value="key")
    private StringConstantParam key;
    @JsonProperty(value="encrypt")
    private StringConstantParam encrypt;

    @JsonCreator
    public EncryptFunction(@JsonProperty(value="field") FieldInfo field, @JsonProperty(value="key") StringConstantParam key, @JsonProperty(value="encrypt") StringConstantParam encrypt) {
        this.field = (FieldInfo)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.key = (StringConstantParam)Preconditions.checkNotNull((Object)key, (Object)"key is null");
        this.encrypt = (StringConstantParam)Preconditions.checkNotNull((Object)encrypt, (Object)"encrypt is null");
    }

    @Override
    public String getName() {
        return "ENCRYPT";
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.field, this.key, this.encrypt);
    }

    @Override
    public String format() {
        return String.format("%s(CAST(%s AS STRING), %s, %s)", this.getName(), this.field.format(), this.key.format(), this.encrypt.format());
    }

    @Override
    public ConstantParam apply(ConstantParam constantParam) {
        return new ConstantParam(String.format("%s(%s, %s, %s)", this.getName(), constantParam.format(), this.key.format(), this.encrypt.format()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptFunction)) {
            return false;
        }
        EncryptFunction other = (EncryptFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FieldInfo this$field = this.getField();
        FieldInfo other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        StringConstantParam this$key = this.getKey();
        StringConstantParam other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        StringConstantParam this$encrypt = this.getEncrypt();
        StringConstantParam other$encrypt = other.getEncrypt();
        return !(this$encrypt == null ? other$encrypt != null : !((Object)this$encrypt).equals(other$encrypt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldInfo $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        StringConstantParam $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        StringConstantParam $encrypt = this.getEncrypt();
        result = result * 59 + ($encrypt == null ? 43 : ((Object)$encrypt).hashCode());
        return result;
    }

    public FieldInfo getField() {
        return this.field;
    }

    public StringConstantParam getKey() {
        return this.key;
    }

    public StringConstantParam getEncrypt() {
        return this.encrypt;
    }

    public void setField(FieldInfo field) {
        this.field = field;
    }

    public void setKey(StringConstantParam key) {
        this.key = key;
    }

    public void setEncrypt(StringConstantParam encrypt) {
        this.encrypt = encrypt;
    }

    public String toString() {
        return "EncryptFunction(field=" + this.getField() + ", key=" + this.getKey() + ", encrypt=" + this.getEncrypt() + ")";
    }
}

