/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.tubemq.server.common.utils.HashedBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowLock {
    private static final Logger logger = LoggerFactory.getLogger(RowLock.class);
    private static final Random rand = new Random();
    private final ConcurrentHashMap<HashedBytes, CountDownLatch> lockedRows = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, HashedBytes> lockIds = new ConcurrentHashMap();
    private final AtomicInteger lockIdGenerator = new AtomicInteger(1);
    private final int rowLockWaitDuration;
    private final String name;

    public RowLock(String lockName, int rowLockWaitDuration) {
        this.rowLockWaitDuration = rowLockWaitDuration;
        this.name = lockName;
    }

    public Integer getLock(Integer lockId, byte[] row, boolean waitForLock) throws IOException {
        return this.getLock(lockId, new HashedBytes(row), waitForLock);
    }

    protected Integer getLock(Integer lockId, HashedBytes row, boolean waitForLock) throws IOException {
        Integer lid;
        if (lockId == null) {
            lid = this.internalObtainRowLock(row, waitForLock);
        } else {
            HashedBytes rowFromLock = this.lockIds.get(lockId);
            if (!row.equals(rowFromLock)) {
                throw new IOException(new StringBuilder(512).append("Invalid row lock: LockId: ").append(lockId).append(" holds the lock for row: ").append(rowFromLock).append(" but wanted lock for row: ").append(row).toString());
            }
            lid = lockId;
        }
        return lid;
    }

    private Integer internalObtainRowLock(HashedBytes rowKey, boolean waitForLock) throws IOException {
        CountDownLatch existingLatch;
        CountDownLatch rowLatch = new CountDownLatch(1);
        while ((existingLatch = this.lockedRows.putIfAbsent(rowKey, rowLatch)) != null) {
            if (!waitForLock) {
                return null;
            }
            try {
                if (existingLatch.await(this.rowLockWaitDuration, TimeUnit.MILLISECONDS)) continue;
                throw new IOException(new StringBuilder(256).append("Timed out on getting lock for row=").append(rowKey).toString());
            }
            catch (InterruptedException interruptedException) {
            }
        }
        Integer lockId;
        while (this.lockIds.putIfAbsent(lockId = Integer.valueOf(this.lockIdGenerator.incrementAndGet()), rowKey) != null) {
            this.lockIdGenerator.set(rand.nextInt());
        }
        return lockId;
    }

    public void releaseRowLock(Integer lockId) {
        if (lockId == null) {
            return;
        }
        HashedBytes rowKey = this.lockIds.remove(lockId);
        if (rowKey == null) {
            logger.warn(new StringBuilder(256).append(this.name).append(" release unknown lockId: ").append(lockId).toString());
            return;
        }
        CountDownLatch rowLatch = this.lockedRows.remove(rowKey);
        if (rowLatch == null) {
            logger.error(new StringBuilder(256).append(this.name).append(" releases row not locked, lockId: ").append(lockId).append(" row: ").append(rowKey).toString());
            return;
        }
        rowLatch.countDown();
    }
}

