/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.client.common.ConfirmResult;
import org.apache.inlong.tubemq.client.common.ConsumeResult;
import org.apache.inlong.tubemq.client.common.PeerInfo;
import org.apache.inlong.tubemq.client.common.QueryMetaResult;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.consumer.ClientBalanceConsumer;
import org.apache.inlong.tubemq.client.consumer.ConsumePosition;
import org.apache.inlong.tubemq.client.consumer.ConsumerResult;
import org.apache.inlong.tubemq.client.consumer.MessageListener;
import org.apache.inlong.tubemq.client.consumer.PullMessageConsumer;
import org.apache.inlong.tubemq.client.consumer.PushMessageConsumer;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.MessageSessionFactory;
import org.apache.inlong.tubemq.client.factory.TubeSingleSessionFactory;
import org.apache.inlong.tubemq.client.producer.MessageProducer;
import org.apache.inlong.tubemq.client.producer.MessageSentCallback;
import org.apache.inlong.tubemq.client.producer.MessageSentResult;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.server.tools.cli.AbstractCommand;
import org.apache.inlong.tubemq.server.tools.cli.AbstractCommandRunner;

@Parameters(commandDescription="Command for message production and consumption")
public class MessageCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public MessageCommand() {
        super("message");
        this.jcommander.addCommand("produce", (Object)new MessageProduce());
        this.jcommander.addCommand("consume", (Object)new MessageConsume());
    }

    @Parameters(commandDescription="Consume message")
    private static class MessageConsume
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-ms", "--master-servers"}, required=true, order=2, description="The master address(es) to connect to. Format is master1_ip:port[,master2_ip:port]")
        private String masterServers;
        @Parameter(names={"-t", "--topic"}, required=true, order=0, description="Topic to consume messages")
        private String topicName;
        @Parameter(names={"-g", "--group"}, required=true, order=1, description="Consumer group")
        private String groupName;
        @Parameter(names={"-m", "--mode"}, order=5, description="Consume mode, must in { pull | push }")
        private String mode = "pull";
        @Parameter(names={"-p", "--position"}, order=3, description="Consume position, must in { first | latest | max }")
        private String consumePosition = "first";
        @Parameter(names={"-po", "--partitions-offsets"}, order=4, description="Consume partition ids and their offsets, format is id1:offset1[,id2:offset2][...], for example: 0:0,1:0,2:0")
        private String consumePartitionsAndOffsets;
        private ClientBalanceConsumer clientBalanceConsumer;
        private PullMessageConsumer messagePullConsumer;
        private PushMessageConsumer messagePushConsumer;
        private AtomicLong msgCount = new AtomicLong(0L);

        private MessageConsume() {
        }

        private void pullConsumer(MessageSessionFactory messageSessionFactory, ConsumerConfig consumerConfig) throws TubeClientException {
            this.messagePullConsumer = messageSessionFactory.createPullConsumer(consumerConfig);
            this.messagePullConsumer.subscribe(this.topicName, null);
            this.messagePullConsumer.completeSubscribe();
            while (!this.messagePullConsumer.isPartitionsReady(1000L)) {
                ThreadUtils.sleep((long)1000L);
            }
            System.out.println("Ready to consume messages......");
            while (true) {
                ConsumerResult result;
                if (!(result = this.messagePullConsumer.getMessage()).isSuccess()) {
                    continue;
                }
                List messageList = result.getMessageList();
                for (Message message : messageList) {
                    System.out.println(new String(message.getData()));
                    this.msgCount.getAndIncrement();
                }
                this.messagePullConsumer.confirmConsume(result.getConfirmContext(), true);
            }
        }

        private void pushConsumer(MessageSessionFactory messageSessionFactory, ConsumerConfig consumerConfig) throws TubeClientException, InterruptedException {
            this.messagePushConsumer = messageSessionFactory.createPushConsumer(consumerConfig);
            this.messagePushConsumer.subscribe(this.topicName, null, new MessageListener(){

                public void receiveMessages(PeerInfo peerInfo, List<Message> messages) throws InterruptedException {
                    for (Message message : messages) {
                        System.out.println(new String(message.getData()));
                        msgCount.getAndIncrement();
                    }
                }

                public Executor getExecutor() {
                    return null;
                }

                public void stop() {
                }
            });
            this.messagePushConsumer.completeSubscribe();
            CountDownLatch latch = new CountDownLatch(1);
            latch.await(10L, TimeUnit.MINUTES);
        }

        private void balanceConsumer(MessageSessionFactory messageSessionFactory, ConsumerConfig consumerConfig) throws TubeClientException {
            this.clientBalanceConsumer = messageSessionFactory.createBalanceConsumer(consumerConfig);
            ProcessResult procResult = new ProcessResult();
            QueryMetaResult qryResult = new QueryMetaResult();
            Map topicAndFiltersMap = MixedUtils.parseTopicParam((String)this.topicName);
            if (!this.clientBalanceConsumer.start(topicAndFiltersMap, -1, 0, procResult)) {
                System.out.println("Initial balance consumer failure, errcode is " + procResult.getErrCode() + " errMsg is " + procResult.getErrMsg());
                return;
            }
            this.clientBalanceConsumer.getPartitionMetaInfo(qryResult);
            Map partMetaInfoMap = qryResult.getPartStatusMap();
            if (partMetaInfoMap != null && !partMetaInfoMap.isEmpty()) {
                Set configuredTopicPartitions = partMetaInfoMap.keySet();
                HashMap<Long, Long> assignedPartitionsAndOffsets = new HashMap<Long, Long>();
                for (String str : this.consumePartitionsAndOffsets.split(",")) {
                    String[] splits = str.split(":");
                    assignedPartitionsAndOffsets.put(Long.parseLong(splits[0]), Long.parseLong(splits[1]));
                }
                Set assignedPartitionIds = assignedPartitionsAndOffsets.keySet();
                HashSet<String> assignedPartitions = new HashSet<String>();
                for (String partKey : configuredTopicPartitions) {
                    long parId = Long.parseLong(partKey.split(":")[2]);
                    if (!((Boolean)partMetaInfoMap.get(partKey)).booleanValue() || !assignedPartitionIds.contains(parId)) continue;
                    assignedPartitions.add(partKey);
                    Long boostrapOffset = (Long)assignedPartitionsAndOffsets.get(parId);
                    if (this.clientBalanceConsumer.connect2Partition(partKey, boostrapOffset == null ? -1L : boostrapOffset, procResult)) continue;
                    System.out.println("connect2Partition failed.");
                }
                ConsumeResult csmResult = new ConsumeResult();
                ConfirmResult cfmResult = new ConfirmResult();
                while (!this.clientBalanceConsumer.isPartitionsReady(1000L)) {
                    ThreadUtils.sleep((long)1000L);
                }
                System.out.println("Ready to consume messages......");
                while (true) {
                    if (!this.clientBalanceConsumer.getMessage(csmResult)) {
                        continue;
                    }
                    List messageList = csmResult.getMessageList();
                    for (Message message : messageList) {
                        System.out.println(new String(message.getData()));
                        this.msgCount.getAndIncrement();
                    }
                    this.clientBalanceConsumer.confirmConsume(csmResult.getConfirmContext(), true, cfmResult);
                }
            }
            System.out.println("No partitions of the topic are available now.");
        }

        @Override
        void run() {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        if (this.clientBalanceConsumer != null) {
                            this.clientBalanceConsumer.shutdown();
                        }
                        if (this.messagePullConsumer != null) {
                            this.messagePullConsumer.shutdown();
                        }
                        if (this.messagePushConsumer != null) {
                            this.messagePushConsumer.shutdown();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    System.out.println(this.msgCount.get() + " message(s) has been consumed. Exited.");
                }));
                ConsumerConfig consumerConfig = new ConsumerConfig(this.masterServers, this.groupName);
                switch (this.consumePosition) {
                    case "first": {
                        consumerConfig.setConsumePosition(ConsumePosition.CONSUMER_FROM_FIRST_OFFSET);
                        break;
                    }
                    case "latest": {
                        consumerConfig.setConsumePosition(ConsumePosition.CONSUMER_FROM_LATEST_OFFSET);
                        break;
                    }
                    case "max": {
                        consumerConfig.setConsumePosition(ConsumePosition.CONSUMER_FROM_MAX_OFFSET_ALWAYS);
                        break;
                    }
                    default: {
                        throw new ParameterException("Consume position, must in { first | latest | max }");
                    }
                }
                TubeSingleSessionFactory messageSessionFactory = new TubeSingleSessionFactory((TubeClientConfig)consumerConfig);
                if (this.consumePartitionsAndOffsets != null) {
                    this.balanceConsumer((MessageSessionFactory)messageSessionFactory, consumerConfig);
                } else {
                    switch (this.mode) {
                        case "pull": {
                            this.pullConsumer((MessageSessionFactory)messageSessionFactory, consumerConfig);
                            break;
                        }
                        case "push": {
                            this.pushConsumer((MessageSessionFactory)messageSessionFactory, consumerConfig);
                            break;
                        }
                        case "balance": {
                            this.balanceConsumer((MessageSessionFactory)messageSessionFactory, consumerConfig);
                            break;
                        }
                        default: {
                            throw new ParameterException("Consume mode, must in { pull | push | balance }");
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Parameters(commandDescription="Produce message")
    private static class MessageProduce
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-ms", "--master-servers"}, required=true, order=1, description="The master address(es) to connect to. Format is master1_ip:port[,master2_ip:port]")
        private String masterServers;
        @Parameter(names={"-t", "--topic"}, required=true, order=0, description="Topic to produce messages")
        private String topicName;
        @Parameter(names={"-mt", "--msg-total"}, order=2, description="The total number of messages to be produced. -1 means unlimited.")
        private long msgTotal = -1L;
        @Parameter(names={"-m", "--mode"}, order=3, description="Produce mode, must in { sync | async }")
        private String mode = "async";
        private String body = "";
        private MessageProducer messageProducer;
        private AtomicLong msgCount = new AtomicLong(0L);

        private MessageProduce() {
        }

        private void syncProduce(Message message) throws TubeClientException, InterruptedException {
            MessageSentResult result = this.messageProducer.sendMessage(message);
            if (!result.isSuccess()) {
                System.out.println("sync send message failed : " + result.getErrMsg());
            } else {
                this.msgCount.getAndIncrement();
            }
        }

        private void asyncProduce(Message message) throws TubeClientException, InterruptedException {
            this.messageProducer.sendMessage(message, new MessageSentCallback(){

                public void onMessageSent(MessageSentResult result) {
                    if (!result.isSuccess()) {
                        System.out.println("async send message failed : " + result.getErrMsg());
                    } else {
                        msgCount.getAndIncrement();
                    }
                }

                public void onException(Throwable e) {
                    System.out.println("async send message error : " + e);
                }
            });
        }

        private void stopProducer(long v) {
            try {
                this.messageProducer.shutdown();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            System.out.println("\n" + v + " message(s) has been produced. Exited.");
        }

        @Override
        void run() {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (this.msgTotal == -1L) {
                        this.stopProducer(this.msgCount.get());
                    }
                }));
                TubeClientConfig clientConfig = new TubeClientConfig(this.masterServers);
                TubeSingleSessionFactory messageSessionFactory = new TubeSingleSessionFactory(clientConfig);
                this.messageProducer = messageSessionFactory.createProducer();
                this.messageProducer.publish(this.topicName);
                Message message = new Message(this.topicName, null);
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                int c = 0;
                while (this.msgTotal == -1L || (long)c < this.msgTotal) {
                    System.out.print(">");
                    this.body = input.readLine();
                    if (this.body == null || "".equals(this.body) || "".equals(this.body.trim())) continue;
                    byte[] bodyData = StringUtils.getBytesUtf8((String)this.body);
                    message.setData(bodyData);
                    switch (this.mode) {
                        case "sync": {
                            this.syncProduce(message);
                            break;
                        }
                        case "async": {
                            this.asyncProduce(message);
                            break;
                        }
                        default: {
                            throw new ParameterException("Produce mode, must in { sync | async }");
                        }
                    }
                    ++c;
                }
                this.stopProducer(this.msgTotal);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

