/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.datagen.table.DataGenConnectorOptions;
import org.apache.flink.connector.datagen.table.DataGenTableSource;
import org.apache.flink.connector.datagen.table.DataGeneratorContainer;
import org.apache.flink.connector.datagen.table.RandomGeneratorVisitor;
import org.apache.flink.connector.datagen.table.SequenceGeneratorVisitor;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;

@Internal
public class DataGenTableSourceFactory
implements DynamicTableSourceFactory {
    public static final String IDENTIFIER = "datagen";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(DataGenConnectorOptions.ROWS_PER_SECOND);
        options.add(DataGenConnectorOptions.NUMBER_OF_ROWS);
        options.add(DataGenConnectorOptions.FIELD_KIND);
        options.add(DataGenConnectorOptions.FIELD_MIN);
        options.add(DataGenConnectorOptions.FIELD_MAX);
        options.add(DataGenConnectorOptions.FIELD_MAX_PAST);
        options.add(DataGenConnectorOptions.FIELD_LENGTH);
        options.add(DataGenConnectorOptions.FIELD_START);
        options.add(DataGenConnectorOptions.FIELD_END);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        String name;
        Configuration options = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)options).setString(arg_0, arg_1));
        DataType rowDataType = context.getPhysicalRowDataType();
        DataGenerator[] fieldGenerators = new DataGenerator[DataType.getFieldCount((DataType)rowDataType)];
        HashSet<Object> optionalOptions = new HashSet<Object>();
        List fieldNames = DataType.getFieldNames((DataType)rowDataType);
        List fieldDataTypes = DataType.getFieldDataTypes((DataType)rowDataType);
        for (int i = 0; i < fieldGenerators.length; ++i) {
            name = (String)fieldNames.get(i);
            DataType type = (DataType)fieldDataTypes.get(i);
            ConfigOption kind = ConfigOptions.key((String)("fields." + name + "." + "kind")).stringType().defaultValue((Object)"random");
            DataGeneratorContainer container = this.createContainer(name, type, (String)options.get(kind), (ReadableConfig)options);
            fieldGenerators[i] = container.getGenerator();
            optionalOptions.add(kind);
            optionalOptions.addAll(container.getOptions());
        }
        FactoryUtil.validateFactoryOptions(this.requiredOptions(), optionalOptions, (ReadableConfig)options);
        HashSet<String> consumedOptionKeys = new HashSet<String>();
        consumedOptionKeys.add(FactoryUtil.CONNECTOR.key());
        consumedOptionKeys.add(DataGenConnectorOptions.ROWS_PER_SECOND.key());
        consumedOptionKeys.add(DataGenConnectorOptions.NUMBER_OF_ROWS.key());
        optionalOptions.stream().map(ConfigOption::key).forEach(consumedOptionKeys::add);
        FactoryUtil.validateUnconsumedKeys((String)this.factoryIdentifier(), (Set)options.keySet(), consumedOptionKeys);
        name = context.getObjectIdentifier().toString();
        return new DataGenTableSource(fieldGenerators, name, rowDataType, (Long)options.get(DataGenConnectorOptions.ROWS_PER_SECOND), (Long)options.get(DataGenConnectorOptions.NUMBER_OF_ROWS));
    }

    private DataGeneratorContainer createContainer(String name, DataType type, String kind, ReadableConfig options) {
        switch (kind) {
            case "random": {
                return (DataGeneratorContainer)type.getLogicalType().accept((LogicalTypeVisitor)new RandomGeneratorVisitor(name, options));
            }
            case "sequence": {
                return (DataGeneratorContainer)type.getLogicalType().accept((LogicalTypeVisitor)new SequenceGeneratorVisitor(name, options));
            }
        }
        throw new ValidationException("Unsupported generator kind: " + kind);
    }
}

