/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.metric;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.file.ConfigManager;
import org.apache.inlong.audit.metric.AbstractMetric;
import org.apache.inlong.audit.metric.MetricItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsManager.class);
    private AbstractMetric metric;
    private final MetricItem metricItem = new MetricItem();
    protected final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public void init() {
        try {
            ConfigManager configManager = ConfigManager.getInstance();
            String metricClassName = configManager.getValue("audit.proxy.metric.classname", "org.apache.inlong.audit.metric.prometheus.ProxyPrometheusMetric");
            LOGGER.info("Metric class name: {}", (Object)metricClassName);
            Constructor<?> constructor = Class.forName(metricClassName).getDeclaredConstructor(MetricItem.class);
            constructor.setAccessible(true);
            this.metric = (AbstractMetric)constructor.newInstance(this.metricItem);
            this.timer.scheduleWithFixedDelay(() -> {
                this.metric.report();
                this.metricItem.resetAllMetrics();
            }, 0L, 1L, TimeUnit.MINUTES);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            LOGGER.error("Init metrics manager has exception: ", (Throwable)exception);
        }
    }

    public static MetricsManager getInstance() {
        return Holder.INSTANCE;
    }

    public void addReceiveCountInvalid(long count) {
        this.metricItem.getReceiveCountInvalid().addAndGet(count);
    }

    public void addReceiveCountExpired(long count) {
        this.metricItem.getReceiveCountExpired().addAndGet(count);
    }

    public void addReceiveSuccess(long count, long pack, long size) {
        this.metricItem.getReceiveCountSuccess().addAndGet(count);
        this.metricItem.getReceivePackSuccess().addAndGet(pack);
        this.metricItem.getReceiveSizeSuccess().addAndGet(size);
    }

    public void addSendSuccess(long count) {
        this.metricItem.getSendCountSuccess().addAndGet(count);
    }

    public void addSendFailed(long count) {
        this.metricItem.getSendCountFailed().addAndGet(count);
    }

    public void shutdown() {
        this.timer.shutdown();
        this.metric.stop();
    }

    private static class Holder {
        private static final MetricsManager INSTANCE = new MetricsManager();

        private Holder() {
        }
    }
}

