/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.greenplum;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumColumnInfo;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenplumSqlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreenplumSqlBuilder.class);

    public static String getCheckTable(String schemaName, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES  WHERE TABLE_SCHEMA = '").append(schemaName).append("' AND TABLE_TYPE = 'BASE TABLE' ").append(" AND TABLE_NAME = '").append(tableName).append("' ;");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String getCheckSchema(String schemaName) {
        return "SELECT COUNT(1) FROM INFORMATION_SCHEMA.SCHEMATA " + " WHERE SCHEMA_NAME = '" + schemaName + "';";
    }

    public static String buildCreateSchema(String schemaName, String user) {
        return " CREATE SCHEMA \"" + schemaName + "\" AUTHORIZATION \"" + user + "\";";
    }

    public static String getCheckColumn(String schemaName, String tableName, String columnName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_SCHEMA = '").append(schemaName).append("' AND TABLE_NAME = '").append(tableName).append("' AND COLUMN_NAME = '").append(columnName).append("' ;");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static List<String> buildCreateTableSql(GreenplumTableInfo table) {
        ArrayList sqls = Lists.newArrayList();
        StringBuilder createSql = new StringBuilder().append("CREATE TABLE ").append(table.getSchemaName()).append(".\"").append(table.getTableName()).append("\"").append(GreenplumSqlBuilder.buildCreateColumnsSql(table));
        sqls.add(createSql.toString());
        sqls.addAll(GreenplumSqlBuilder.getColumnsComment(table.getSchemaName(), table.getTableName(), table.getColumns()));
        if (StringUtils.isNotEmpty((CharSequence)table.getComment())) {
            sqls.add(GreenplumSqlBuilder.getTableComment(table));
        }
        LOGGER.info("create table sql : {}", (Object)sqls);
        return sqls;
    }

    public static List<String> buildAddColumnsSql(String schemaName, String tableName, List<GreenplumColumnInfo> columnList) {
        ArrayList resultList = Lists.newArrayList();
        StringBuilder sqlBuilder = new StringBuilder();
        columnList.forEach(columnInfo -> {
            sqlBuilder.append("ALTER TABLE \"").append(schemaName).append("\".\"").append(tableName).append("\" ADD \"").append(columnInfo.getName()).append("\" ").append(columnInfo.getType()).append(" ");
            resultList.add(sqlBuilder.toString());
            sqlBuilder.delete(0, sqlBuilder.length());
        });
        resultList.addAll(GreenplumSqlBuilder.getColumnsComment(schemaName, tableName, columnList));
        LOGGER.info("add columns sql={}", (Object)resultList);
        return resultList;
    }

    private static String buildCreateColumnsSql(GreenplumTableInfo table) {
        List<String> columnList = GreenplumSqlBuilder.getColumnsInfo(table.getColumns());
        StringBuilder sql = new StringBuilder().append(" (").append(StringUtils.join(columnList, (String)","));
        if (!StringUtils.isEmpty((CharSequence)table.getPrimaryKey())) {
            sql.append(", PRIMARY KEY (").append(table.getPrimaryKey()).append(")");
        }
        sql.append(") ");
        return sql.toString();
    }

    private static List<String> getColumnsInfo(List<GreenplumColumnInfo> columns) {
        ArrayList<String> columnList = new ArrayList<String>();
        StringBuilder columnBuilder = new StringBuilder();
        columns.forEach(columnInfo -> {
            columnBuilder.append("\"").append(columnInfo.getName()).append("\" ").append(columnInfo.getType());
            columnList.add(columnBuilder.toString());
            columnBuilder.delete(0, columnBuilder.length());
        });
        return columnList;
    }

    private static List<String> getColumnsComment(String schemaName, String tableName, List<GreenplumColumnInfo> columns) {
        ArrayList<String> commentList = new ArrayList<String>();
        for (GreenplumColumnInfo columnInfo : columns) {
            if (!StringUtils.isNotBlank((CharSequence)columnInfo.getComment())) continue;
            StringBuilder commSql = new StringBuilder();
            commSql.append("COMMENT ON COLUMN \"").append(schemaName).append("\".\"").append(tableName).append("\".\"").append(columnInfo.getName()).append("\" IS '").append(columnInfo.getComment()).append("' ;");
            commentList.add(commSql.toString());
        }
        return commentList;
    }

    private static String getTableComment(GreenplumTableInfo tableInfo) {
        return "COMMENT ON TABLE \"" + tableInfo.getSchemaName() + "\".\"" + tableInfo.getTableName() + "\" IS '" + tableInfo.getComment() + "';";
    }

    public static String buildDescTableSql(String schemaName, String tableName) {
        StringBuilder sql = new StringBuilder().append("SELECT A.COLUMN_NAME,A.UDT_NAME,C.DESCRIPTION FROM INFORMATION_SCHEMA.COLUMNS A").append(" LEFT JOIN   (SELECT PC.OID AS OOID,PN.NSPNAME,PC.RELNAME").append(" FROM PG_CLASS PC LEFT OUTER JOIN PG_NAMESPACE PN ON PC.RELNAMESPACE = PN.OID ").append(" WHERE PN.NSPNAME ='").append(schemaName).append("' AND PC.RELNAME = '").append(tableName).append("') B   ON A.TABLE_SCHEMA = B.NSPNAME AND A.TABLE_NAME = B.RELNAME").append(" LEFT JOIN PG_CATALOG.PG_DESCRIPTION C ").append("ON B.OOID = C.OBJOID AND A.ORDINAL_POSITION = C.OBJSUBID").append(" WHERE A.TABLE_SCHEMA = '").append(schemaName).append("' AND A.TABLE_NAME = '").append(tableName).append("'  ORDER BY  C.OBJSUBID ;");
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }
}

