/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group;

import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.listener.GroupTaskListenerFactory;
import org.apache.inlong.manager.service.listener.group.UpdateGroupCompleteListener;
import org.apache.inlong.manager.service.listener.group.UpdateGroupFailedListener;
import org.apache.inlong.manager.service.listener.group.UpdateGroupListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestartGroupWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(RestartGroupWorkflowDefinition.class);
    @Autowired
    private UpdateGroupListener updateGroupListener;
    @Autowired
    private UpdateGroupCompleteListener updateGroupCompleteListener;
    @Autowired
    private UpdateGroupFailedListener updateGroupFailedListener;
    @Autowired
    private GroupTaskListenerFactory taskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(GroupResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        process.addListener((ProcessEventListener)this.updateGroupListener);
        process.addListener((ProcessEventListener)this.updateGroupCompleteListener);
        process.addListener((ProcessEventListener)this.updateGroupFailedListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask restartSortTask = new ServiceTask();
        restartSortTask.setName("RestartSort");
        restartSortTask.setDisplayName("Group-RestartSort");
        restartSortTask.setServiceTaskType(ServiceTaskType.RESTART_SORT);
        restartSortTask.setListenerFactory((TaskListenerFactory)this.taskListenerFactory);
        process.addTask((WorkflowTask)restartSortTask);
        ServiceTask restartSourceTask = new ServiceTask();
        restartSourceTask.setName("RestartSource");
        restartSourceTask.setDisplayName("Group-RestartSource");
        restartSourceTask.setServiceTaskType(ServiceTaskType.RESTART_SOURCE);
        restartSourceTask.setListenerFactory((TaskListenerFactory)this.taskListenerFactory);
        process.addTask((WorkflowTask)restartSourceTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)restartSortTask);
        restartSortTask.addNext((Element)restartSourceTask);
        restartSourceTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.RESTART_GROUP_PROCESS;
    }
}

