/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.header.Headerable;
import org.apache.juneau.http.part.BasicBooleanPart;
import org.apache.juneau.http.part.BasicCsvArrayPart;
import org.apache.juneau.http.part.BasicDatePart;
import org.apache.juneau.http.part.BasicIntegerPart;
import org.apache.juneau.http.part.BasicLongPart;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.http.part.BasicUriPart;
import org.apache.juneau.http.part.NameValuePairable;
import org.apache.juneau.http.part.PartList;
import org.apache.juneau.http.part.SerializedPart;
import org.apache.juneau.httppart.HttpPartType;

public class HttpParts {
    private static final Function<ClassMeta<?>, String> HEADER_NAME_FUNCTION = x -> {
        Value<Object> n = Value.empty();
        x.forEachAnnotation(Header.class, y -> Utils.ne(y.value()), y -> n.set(y.value()));
        x.forEachAnnotation(Header.class, y -> Utils.ne(y.name()), y -> n.set(y.name()));
        return n.orElse(null);
    };
    private static final Function<ClassMeta<?>, String> QUERY_NAME_FUNCTION = x -> {
        Value<Object> n = Value.empty();
        x.forEachAnnotation(Query.class, y -> Utils.ne(y.value()), y -> n.set(y.value()));
        x.forEachAnnotation(Query.class, y -> Utils.ne(y.name()), y -> n.set(y.name()));
        return n.orElse(null);
    };
    private static final Function<ClassMeta<?>, String> FORMDATA_NAME_FUNCTION = x -> {
        Value<Object> n = Value.empty();
        x.forEachAnnotation(FormData.class, y -> Utils.ne(y.value()), y -> n.set(y.value()));
        x.forEachAnnotation(FormData.class, y -> Utils.ne(y.name()), y -> n.set(y.name()));
        return n.orElse(null);
    };
    private static final Function<ClassMeta<?>, String> PATH_NAME_FUNCTION = x -> {
        Value<Object> n = Value.empty();
        x.forEachAnnotation(Path.class, y -> Utils.ne(y.value()), y -> n.set(y.value()));
        x.forEachAnnotation(Path.class, y -> Utils.ne(y.name()), y -> n.set(y.name()));
        return n.orElse(null);
    };
    private static final Function<ClassMeta<?>, ConstructorInfo> CONSTRUCTOR_FUNCTION = x -> x.getPublicConstructor(y -> y.hasParameterTypes(String.class)).orElseGet(() -> x.getPublicConstructor(y -> y.hasParameterTypes(String.class, String.class)).orElse(null));

    public static final BasicPart basicPart(String pair) {
        return BasicPart.ofPair(pair);
    }

    public static final BasicPart basicPart(String name, Object value) {
        return BasicPart.of(name, value);
    }

    public static final BasicPart basicPart(String name, Supplier<?> value) {
        return BasicPart.of(name, value);
    }

    public static final BasicBooleanPart booleanPart(String name, Boolean value) {
        return BasicBooleanPart.of(name, value);
    }

    public static final BasicBooleanPart booleanPart(String name, Supplier<Boolean> value) {
        return BasicBooleanPart.of(name, value);
    }

    public static boolean canCast(Object o) {
        if (o == null) {
            return false;
        }
        ClassInfo ci = ClassInfo.of(o);
        return Utils.nn(ci) && ci.isChildOfAny(Headerable.class, NameValuePair.class, NameValuePairable.class, Map.Entry.class);
    }

    public static NameValuePair cast(Object o) {
        if (o instanceof NameValuePair) {
            NameValuePair o2 = (NameValuePair)o;
            return o2;
        }
        if (o instanceof Headerable) {
            Headerable o3 = (Headerable)o;
            org.apache.http.Header x = o3.asHeader();
            return BasicPart.of(x.getName(), x.getValue());
        }
        if (o instanceof Map.Entry) {
            Map.Entry o4 = (Map.Entry)o;
            return BasicPart.of(Utils.s(o4.getKey()), o4.getValue());
        }
        throw ThrowableUtils.rex("Object of type {0} could not be converted to a Part.", Utils.cn(o));
    }

    public static final BasicCsvArrayPart csvArrayPart(String name, String ... value) {
        return BasicCsvArrayPart.of(name, value);
    }

    public static final BasicCsvArrayPart csvArrayPart(String name, Supplier<String[]> value) {
        return BasicCsvArrayPart.of(name, value);
    }

    public static final BasicDatePart datePart(String name, Supplier<ZonedDateTime> value) {
        return BasicDatePart.of(name, value);
    }

    public static final BasicDatePart datePart(String name, ZonedDateTime value) {
        return BasicDatePart.of(name, value);
    }

    public static Optional<ConstructorInfo> getConstructor(ClassMeta<?> type) {
        return type.getProperty("HttpPart.Constructor", CONSTRUCTOR_FUNCTION);
    }

    public static Optional<String> getName(HttpPartType partType, ClassMeta<?> type) {
        return switch (partType) {
            case HttpPartType.FORMDATA -> type.getProperty("HttpPart.formData.name", FORMDATA_NAME_FUNCTION);
            case HttpPartType.HEADER -> type.getProperty("HttpPart.header.name", HEADER_NAME_FUNCTION);
            case HttpPartType.PATH -> type.getProperty("HttpPart.path.name", PATH_NAME_FUNCTION);
            case HttpPartType.QUERY -> type.getProperty("HttpPart.query.name", QUERY_NAME_FUNCTION);
            default -> Utils.opte();
        };
    }

    public static final BasicIntegerPart integerPart(String name, Integer value) {
        return BasicIntegerPart.of(name, value);
    }

    public static final BasicIntegerPart integerPart(String name, Supplier<Integer> value) {
        return BasicIntegerPart.of(name, value);
    }

    public static boolean isHttpPart(HttpPartType partType, ClassMeta<?> type) {
        return switch (partType) {
            case HttpPartType.FORMDATA, HttpPartType.PATH, HttpPartType.QUERY -> type.getProperty("HttpPart.isNameValuePair", x -> x.isChildOf(NameValuePair.class)).orElse(false);
            case HttpPartType.HEADER -> type.getProperty("HttpPart.isHeader", x -> x.isChildOf(org.apache.http.Header.class)).orElse(false);
            default -> false;
        };
    }

    public static final BasicLongPart longPart(String name, Long value) {
        return BasicLongPart.of(name, value);
    }

    public static final BasicLongPart longPart(String name, Supplier<Long> value) {
        return BasicLongPart.of(name, value);
    }

    public static final PartList partList() {
        return PartList.create();
    }

    public static final PartList partList(List<NameValuePair> parts) {
        return PartList.of(parts);
    }

    public static final PartList partList(NameValuePair ... parts) {
        return PartList.of(parts);
    }

    public static PartList partList(String ... pairs) {
        return PartList.ofPairs(pairs);
    }

    public static final SerializedPart serializedPart(String name, Object value) {
        return SerializedPart.of(name, value);
    }

    public static final SerializedPart serializedPart(String name, Supplier<?> value) {
        return SerializedPart.of(name, value);
    }

    public static final BasicStringPart stringPart(String name, String value) {
        return BasicStringPart.of(name, value);
    }

    public static final BasicStringPart stringPart(String name, Supplier<String> value) {
        return BasicStringPart.of(name, value);
    }

    public static final BasicUriPart uriPart(String name, Supplier<URI> value) {
        return BasicUriPart.of(name, value);
    }

    public static final BasicUriPart uriPart(String name, URI value) {
        return BasicUriPart.of(name, value);
    }
}

