/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Optional;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;

public class BeanBuilder<T> {
    private Class<? extends T> type;
    private Class<? extends T> defaultType;
    private T impl;
    private final BeanStore beanStore;

    protected BeanBuilder(BeanBuilder<T> copyFrom) {
        this.type = copyFrom.type;
        this.impl = copyFrom.impl;
        this.beanStore = copyFrom.beanStore;
    }

    protected BeanBuilder(Class<? extends T> defaultType, BeanStore beanStore) {
        this.type = defaultType;
        this.defaultType = this.type;
        this.beanStore = beanStore;
    }

    public BeanStore beanStore() {
        return this.beanStore;
    }

    public T build() {
        if (Utils.nn(this.impl)) {
            return this.impl;
        }
        if (this.type == null || this.type == this.defaultType) {
            return this.buildDefault();
        }
        return this.creator().run();
    }

    public BeanBuilder<T> impl(Object value) {
        this.impl = value;
        return this;
    }

    public BeanBuilder<T> type(Class<?> value) {
        this.type = value;
        return this;
    }

    protected T buildDefault() {
        return this.beanStore.createBean(this.type().orElseThrow(() -> new IllegalStateException("Type not specified."))).builder(BeanBuilder.class, this).run();
    }

    protected BeanCreator<? extends T> creator() {
        return this.beanStore.createBean(this.type().orElseThrow(() -> new IllegalStateException("Type not specified."))).builder(BeanBuilder.class, this);
    }

    protected Optional<T> impl() {
        return Utils.opt(this.impl);
    }

    protected Optional<Class<? extends T>> type() {
        return Utils.opt(this.type);
    }
}

