/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.EngineRef$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.chat.ChatProcessBuilder;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder;
import org.apache.kyuubi.engine.hive.HiveProcessBuilder$;
import org.apache.kyuubi.engine.jdbc.JdbcProcessBuilder$;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.trino.TrinoProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.util.JavaUtils;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t%e!\u0002\u001c8\u0001ez\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011I\u0003!\u0011!Q\u0001\nMC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"A\u0011\u000e\u0001B\u0001B\u0003%1\u000b\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011!y\u0007A!A!\u0002\u0013\u0001\b\"B?\u0001\t\u0003q\b\"CA\b\u0001\t\u0007I\u0011BA\t\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nMC\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005}\u0001\u0001)A\u0005\u00033A\u0011\"!\t\u0001\u0005\u0004%I!a\t\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003KA\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0017\t\u0011\u0005\r\u0004\u0001)A\u0005\u0003;B\u0011\"!\u001a\u0001\u0005\u0004%I!a\u0017\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003;B\u0011\"!\u001b\u0001\u0005\u0004%I!!\u0005\t\u000f\u0005-\u0004\u0001)A\u0005'\"I\u0011Q\u000e\u0001C\u0002\u0013%\u0011q\u000e\u0005\b\u0003c\u0002\u0001\u0015!\u0003`\u0011%\t\u0019\b\u0001b\u0001\n\u0013\t\t\u0002C\u0004\u0002v\u0001\u0001\u000b\u0011B*\t\u0015\u0005]\u0004\u0001#b\u0001\n\u0013\tI\bC\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0003\u0002\b\"A\u0011q\u0012\u0001!\u0002\u0013\tI\tC\u0006\u0002\u0012\u0002\u0001\r\u00111A\u0005\n\u0005M\u0005bCAN\u0001\u0001\u0007\t\u0019!C\u0005\u0003;C1\"!+\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0016\"A\u00111\u0016\u0001\u0005\u0002e\n\t\u0002\u0003\u0006\u0002.\u0002\u0011\r\u0011\"\u0001:\u0003#Aq!a,\u0001A\u0003%1\u000b\u0003\u0006\u00022\u0002\u0011\r\u0011\"\u0001:\u0003#Aq!a-\u0001A\u0003%1\u000b\u0003\u0006\u00026\u0002\u0011\r\u0011\"\u0001:\u0003#Aq!a.\u0001A\u0003%1\u000b\u0003\u0006\u0002T\u0002\u0011\r\u0011\"\u0001:\u0003#Aq!!6\u0001A\u0003%1\u000bC\u0006\u0002Z\u0002A)\u0019!C\u0001s\u0005E\u0001bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005{A\u0011Ba\u0011\u0001#\u0003%\tA!\u0012\t\u000f\tm\u0003\u0001\"\u0001\u0003^!9!q\r\u0001\u0005\u0002\t%\u0004b\u0002B<\u0001\u0011\u0005!\u0011P\u0004\u000b\u0005w:\u0014\u0011!E\u0001s\tud!\u0003\u001c8\u0003\u0003E\t!\u000fB@\u0011\u0019i8\u0007\"\u0001\u0003\u0002\"I!1Q\u001a\u0012\u0002\u0013\u0005!Q\u0011\u0002\n\u000b:<\u0017N\\3SK\u001aT!\u0001O\u001d\u0002\r\u0015tw-\u001b8f\u0015\tQ4(\u0001\u0004lsV,(-\u001b\u0006\u0003yu\na!\u00199bG\",'\"\u0001 \u0002\u0007=\u0014xmE\u0002\u0001\u0001\u001a\u0003\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013a!\u00118z%\u00164\u0007CA$I\u001b\u0005I\u0014BA%:\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001CA'Q\u001b\u0005q%BA(:\u0003\u0019\u0019wN\u001c4jO&\u0011\u0011K\u0014\u0002\u000b\u0017f,XOY5D_:4\u0017aC:fgNLwN\\+tKJ\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,C\u001b\u00059&B\u0001-L\u0003\u0019a$o\\8u}%\u0011!LQ\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[\u0005\u0006YAm\\!t\u000b:\f'\r\\3e!\t\t\u0005-\u0003\u0002b\u0005\n9!i\\8mK\u0006t\u0017!D4s_V\u0004\bK]8wS\u0012,'\u000f\u0005\u0002eO6\tQM\u0003\u0002gs\u00051\u0001\u000f\\;hS:L!\u0001[3\u0003\u001b\u001d\u0013x.\u001e9Qe>4\u0018\u000eZ3s\u0003-)gnZ5oKJ+g-\u00133\u0002\u001b\u0015tw-\u001b8f\u001b\u0006t\u0017mZ3s!\taW.D\u00018\u0013\tqwG\u0001\rLsV,(-[!qa2L7-\u0019;j_:l\u0015M\\1hKJ\fqc\u001d;beR,\b\u000f\u0015:pG\u0016\u001c8oU3nCBDwN]3\u0011\u0007\u0005\u000b8/\u0003\u0002s\u0005\n1q\n\u001d;j_:\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002ys\u0006!Q\u000f^5m\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001`;\u0003\u0013M+W.\u00199i_J,\u0017A\u0002\u001fj]&$h\bF\b\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007!\ta\u0007\u0001C\u0003K\u0011\u0001\u0007A\nC\u0003S\u0011\u0001\u00071\u000bC\u0003_\u0011\u0001\u0007q\fC\u0003c\u0011\u0001\u00071\rC\u0003j\u0011\u0001\u00071\u000bC\u0003k\u0011\u0001\u00071\u000eC\u0004p\u0011A\u0005\t\u0019\u00019\u0002\u0017M,'O^3s'B\f7-Z\u000b\u0002'\u0006a1/\u001a:wKJ\u001c\u0006/Y2fA\u00059A/[7f_V$XCAA\r!\r\t\u00151D\u0005\u0004\u0003;\u0011%\u0001\u0002'p]\u001e\f\u0001\u0002^5nK>,H\u000fI\u0001\u000bg\"\f'/\u001a'fm\u0016dWCAA\u0013!\u0011\t9#!\u0010\u000f\t\u0005%\u0012\u0011\b\b\u0005\u0003W\t9D\u0004\u0003\u0002.\u0005Ub\u0002BA\u0018\u0003gq1AVA\u0019\u0013\u0005q\u0014B\u0001\u001f>\u0013\tQ4(\u0003\u00029s%\u0019\u00111H\u001c\u0002\u0015MC\u0017M]3MKZ,G.\u0003\u0003\u0002@\u0005\u0005#AC*iCJ,G*\u001a<fY*\u0019\u00111H\u001c\u0002\u0017MD\u0017M]3MKZ,G\u000eI\u0001\u000bK:<\u0017N\\3UsB,WCAA%!\u0011\tY%!\u0015\u000f\t\u0005%\u0012QJ\u0005\u0004\u0003\u001f:\u0014AC#oO&tW\rV=qK&!\u00111KA+\u0005))enZ5oKRK\b/\u001a\u0006\u0004\u0003\u001f:\u0014aC3oO&tW\rV=qK\u0002\nQ\u0002]8pYRC'/Z:i_2$WCAA/!\r\t\u0015qL\u0005\u0004\u0003C\u0012%aA%oi\u0006q\u0001o\\8m)\"\u0014Xm\u001d5pY\u0012\u0004\u0013AD2mS\u0016tG\u000fU8pYNK'0Z\u0001\u0010G2LWM\u001c;Q_>d7+\u001b>fA\u0005q1\r\\5f]R\u0004vn\u001c7OC6,\u0017aD2mS\u0016tG\u000fU8pY:\u000bW.\u001a\u0011\u00023\u0015tw-\u001b8f!>|G.S4o_J,7+\u001e2e_6\f\u0017N\\\u000b\u0002?\u0006QRM\\4j]\u0016\u0004vn\u001c7JO:|'/Z*vE\u0012|W.Y5oA\u00051RM\\4j]\u0016\u0004vn\u001c7TK2,7\r\u001e)pY&\u001c\u00170A\ff]\u001eLg.\u001a)p_2\u001cV\r\\3diB{G.[2zA\u0005iAn\\2bY\"{7\u000f^!eIJ,\"!a\u001f\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!z\u0003\u0011a\u0017M\\4\n\u0007q\u000by(\u0001\rM\u001f\u000e[u\fV%N\u000b>+FkX*Q\u0003:{f)Q\"U\u001fJ+\"!!#\u0011\u0007\u0005\u000bY)C\u0002\u0002\u000e\n\u0013a\u0001R8vE2,\u0017!\u0007'P\u0007.{F+S'F\u001fV#vl\u0015)B\u001d~3\u0015i\u0011+P%\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002\u0016B\u0019A.a&\n\u0007\u0005euGA\u0006Qe>\u001c')^5mI\u0016\u0014\u0018a\u00032vS2$WM]0%KF$B!a(\u0002&B\u0019\u0011)!)\n\u0007\u0005\r&I\u0001\u0003V]&$\b\"CAT?\u0005\u0005\t\u0019AAK\u0003\rAH%M\u0001\tEVLG\u000eZ3sA\u0005qq-\u001a;F]\u001eLg.\u001a*fM&#\u0017a\u0003:pkRLgnZ+tKJ\fAB]8vi&tw-V:fe\u0002\nq!\u00199q+N,'/\u0001\u0005baB,6/\u001a:!\u0003%\u0019XO\u00193p[\u0006Lg.\u0001\u0006tk\n$w.\\1j]\u0002B3aJA^!\u0011\ti,a4\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\f1\"\u00198o_R\fG/[8og*!\u0011QYAd\u0003\u0019\u0019w.\\7p]*!\u0011\u0011ZAf\u0003\u00199wn\\4mK*\u0011\u0011QZ\u0001\u0004G>l\u0017\u0002BAi\u0003\u007f\u0013\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h\u0003E!WMZ1vYR,enZ5oK:\u000bW.Z\u0001\u0013I\u00164\u0017-\u001e7u\u000b:<\u0017N\\3OC6,\u0007\u0005K\u0002*\u0003w\u000b1\"\u001a8hS:,7\u000b]1dK\"\u001a!&a/\u0002\u0017Q\u0014\u0018pV5uQ2{7m[\u000b\u0005\u0003C\fI\u000f\u0006\u0003\u0002d\n\u0015A\u0003BAs\u0003w\u0004B!a:\u0002j2\u0001AaBAvW\t\u0007\u0011Q\u001e\u0002\u0002)F!\u0011q^A{!\r\t\u0015\u0011_\u0005\u0004\u0003g\u0014%a\u0002(pi\"Lgn\u001a\t\u0004\u0003\u0006]\u0018bAA}\u0005\n\u0019\u0011I\\=\t\u0011\u0005u8\u0006\"a\u0001\u0003\u007f\f\u0011A\u001a\t\u0006\u0003\n\u0005\u0011Q]\u0005\u0004\u0005\u0007\u0011%\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\t\u001d1\u00061\u0001\u0003\n\u0005yA-[:d_Z,'/_\"mS\u0016tG\u000f\u0005\u0003\u0003\f\tUQB\u0001B\u0007\u0015\u0011\u0011yA!\u0005\u0002\r\rd\u0017.\u001a8u\u0015\r\u0011\u0019\"O\u0001\u0003Q\u0006LAAa\u0006\u0003\u000e\tyA)[:d_Z,'/_\"mS\u0016tG/\u0001\u0004de\u0016\fG/\u001a\u000b\u0007\u0005;\u0011\u0019C!\n\u0011\r\u0005\u0013ybUA/\u0013\r\u0011\tC\u0011\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t\u001dA\u00061\u0001\u0003\n!9!q\u0005\u0017A\u0002\t%\u0012AD3yiJ\fWI\\4j]\u0016dun\u001a\t\u0005\u0003F\u0014Y\u0003\u0005\u0003\u0003.\t]RB\u0001B\u0018\u0015\u0011\u0011\tDa\r\u0002\u00071|wMC\u0002\u00036e\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\t\te\"q\u0006\u0002\r\u001fB,'/\u0019;j_:dunZ\u0001\fO\u0016$xJ]\"sK\u0006$X\r\u0006\u0004\u0003\u001e\t}\"\u0011\t\u0005\b\u0005\u000fi\u0003\u0019\u0001B\u0005\u0011%\u00119#\fI\u0001\u0002\u0004\u0011I#A\u000bhKR|%o\u0011:fCR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u001d#\u0006\u0002B\u0015\u0005\u0013Z#Aa\u0013\u0011\t\t5#qK\u0007\u0003\u0005\u001fRAA!\u0015\u0003T\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005+\u0012\u0015AC1o]>$\u0018\r^5p]&!!\u0011\fB(\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bI\u0016\u0014XmZ5ti\u0016\u0014HC\u0002B0\u0005C\u0012\u0019\u0007E\u0003B\u0005?y6\u000bC\u0004\u0003\b=\u0002\rA!\u0003\t\u000f\t\u0015t\u00061\u0001\u0003\u001e\u0005A\u0001n\\:u!>\u0014H/\u0001\bhKR\u001cVM\u001d<jG\u0016tu\u000eZ3\u0015\r\t-$1\u000fB;!\u0011\t\u0015O!\u001c\u0011\t\t-!qN\u0005\u0005\u0005c\u0012iAA\bTKJ4\u0018nY3O_\u0012,\u0017J\u001c4p\u0011\u001d\u00119\u0001\ra\u0001\u0005\u0013AqA!\u001a1\u0001\u0004\u0011i\"A\u0003dY>\u001cX\r\u0006\u0002\u0002 \u0006IQI\\4j]\u0016\u0014VM\u001a\t\u0003YN\u001a\"a\r!\u0015\u0005\tu\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003\b*\u001a\u0001O!\u0013")
public class EngineRef
implements Logging {
    private String localHostAddr;
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final boolean doAsEnabled;
    private final String engineRefId;
    private final KyuubiApplicationManager engineManager;
    private final Option<Semaphore> startupProcessSemaphore;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    private final String clientPoolName;
    private final boolean enginePoolIgnoreSubdomain;
    private final String enginePoolSelectPolicy;
    private final double LOCK_TIMEOUT_SPAN_FACTOR;
    private ProcBuilder builder;
    private final String routingUser;
    private final String appUser;
    @VisibleForTesting
    private final String subdomain;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<Semaphore> $lessinit$greater$default$7() {
        return EngineRef$.MODULE$.$lessinit$greater$default$7();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    private String clientPoolName() {
        return this.clientPoolName;
    }

    private boolean enginePoolIgnoreSubdomain() {
        return this.enginePoolIgnoreSubdomain;
    }

    private String enginePoolSelectPolicy() {
        return this.enginePoolSelectPolicy;
    }

    /*
     * WARNING - void declaration
     */
    private String localHostAddr$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                String host = JavaUtils.findLocalInetAddress().getHostAddress();
                if (StringUtils.isBlank((CharSequence)host)) {
                    throw KyuubiSQLException$.MODULE$.apply("Local host address can not be empty if ShareLevel set to SERVER_LOCAL", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                }
                this.localHostAddr = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.localHostAddr;
    }

    private String localHostAddr() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.localHostAddr$lzycompute();
        }
        return this.localHostAddr;
    }

    private double LOCK_TIMEOUT_SPAN_FACTOR() {
        return this.LOCK_TIMEOUT_SPAN_FACTOR;
    }

    private ProcBuilder builder() {
        return this.builder;
    }

    private void builder_$eq(ProcBuilder x$1) {
        this.builder = x$1;
    }

    public String getEngineRefId() {
        return this.engineRefId;
    }

    public String routingUser() {
        return this.routingUser;
    }

    public String appUser() {
        return this.appUser;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String string;
                String commonParent = new StringBuilder(3).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    string = DiscoveryPaths$.MODULE$.makePath(commonParent, this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.engineRefId}));
                } else {
                    Enumeration.Value value4 = ShareLevel$.MODULE$.SERVER_LOCAL();
                    Enumeration.Value value5 = value;
                    string = !(value4 != null ? !value4.equals(value5) : value5 != null) ? DiscoveryPaths$.MODULE$.makePath(commonParent, this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(1).append(this.localHostAddr()).append("_").append(this.subdomain()).toString()})) : DiscoveryPaths$.MODULE$.makePath(commonParent, this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
                }
                this.engineSpace = string;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.engineSpace$lzycompute();
        }
        return this.engineSpace;
    }

    private <T> T tryWithLock(DiscoveryClient discoveryClient, Function0<T> f) {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (T)f.apply();
        }
        Enumeration.Value value4 = ShareLevel$.MODULE$.SERVER_LOCAL();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            String lockPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(8).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_lock").toString(), this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(1).append(this.localHostAddr()).append("_").append(this.subdomain()).toString()}));
            return (T)discoveryClient.tryWithLock(lockPath, this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), f);
        }
        String lockPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(8).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_lock").toString(), this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
        return (T)discoveryClient.tryWithLock(lockPath, this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), f);
    }

    private Tuple2<String, Object> create(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
                boolean destroyProcess;
                Tuple2 tuple2;
                Logging logging;
                Option engineRef = discoveryClient.getServerHost(this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID(), (Object)$this.engineRefId);
                long started = System.currentTimeMillis();
                $this.conf.set("kyuubi.engine.submit.time", String.valueOf(started));
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                    logging = new SparkProcessBuilder(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog);
                } else {
                    Enumeration.Value value4 = EngineType$.MODULE$.FLINK_SQL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        $this.conf.setIfMissing("flink.app.name", this.defaultEngineName());
                        logging = new FlinkProcessBuilder(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog);
                    } else {
                        Enumeration.Value value6 = EngineType$.MODULE$.TRINO();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logging = new TrinoProcessBuilder(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog);
                        } else {
                            Enumeration.Value value8 = EngineType$.MODULE$.HIVE_SQL();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                $this.conf.setIfMissing("hive.engine.name", this.defaultEngineName());
                                logging = HiveProcessBuilder$.MODULE$.apply(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog, this.defaultEngineName());
                            } else {
                                Enumeration.Value value10 = EngineType$.MODULE$.JDBC();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    $this.conf.setIfMissing("jdbc.engine.name", this.defaultEngineName());
                                    logging = JdbcProcessBuilder$.MODULE$.apply(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog, this.defaultEngineName());
                                } else {
                                    Enumeration.Value value12 = EngineType$.MODULE$.CHAT();
                                    Enumeration.Value value13 = value;
                                    if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                        logging = new ChatProcessBuilder(this.appUser(), $this.doAsEnabled, $this.conf, $this.engineRefId, extraEngineLog);
                                    } else {
                                        throw new MatchError((Object)value);
                                    }
                                }
                            }
                        }
                    }
                }
                this.builder_$eq((ProcBuilder)logging);
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                boolean acquiredPermit = false;
                try {
                    if (!$this.startupProcessSemaphore.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.tryAcquire(this.timeout(), TimeUnit.MILLISECONDS)))) {
                        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                            x$4.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                            return BoxedUnit.UNIT;
                        });
                        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(94).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" acquires a permit from engine builder semaphore.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                    }
                    acquiredPermit = true;
                    String redactedCmd = this.builder().toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(redactedCmd).toString());
                    this.builder().validateConf();
                    Process process = this.builder().start();
                    None$ exitValue = None$.MODULE$;
                    ObjectRef lastApplicationInfo = ObjectRef.create((Object)None$.MODULE$);
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS)) {
                            exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
                            if (exitValue.contains((Object)BoxesRunTime.boxToInteger((int)0))) {
                                acquiredPermit = false;
                                $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                                    x$5.release();
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                Throwable error = this.builder().getError();
                                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                    EngineRef.$anonfun$create$7(this, error, ms);
                                    return BoxedUnit.UNIT;
                                });
                                throw error;
                            }
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            Tuple2<Object, String> killMessage = $this.engineManager.killApplication(this.builder().appMgrInfo(), $this.engineRefId, (Option<String>)new Some((Object)this.appUser()));
                            this.builder().close(true);
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$6 -> {
                                x$6.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(70).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" launched ").append(this.engineType()).append(" engine with ").append(redactedCmd).append(". ").append(killMessage).toString(), this.builder().getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = discoveryClient.getEngineByRefId(this.engineSpace(), $this.engineRefId);
                        if (!engineRef.isEmpty() || !exitValue.contains((Object)BoxesRunTime.boxToInteger((int)0))) continue;
                        Option$.MODULE$.apply((Object)$this.engineManager).foreach((Function1 & Serializable & scala.Serializable)engineMgr -> {
                            EngineRef.$anonfun$create$9(this, lastApplicationInfo, started, engineMgr);
                            return BoxedUnit.UNIT;
                        });
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                catch (Throwable throwable) {
                    boolean destroyProcess2;
                    if (acquiredPermit) {
                        $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                            x$7.release();
                            return BoxedUnit.UNIT;
                        });
                    }
                    boolean bl = destroyProcess2 = !this.builder().waitEngineCompletion();
                    if (destroyProcess2) {
                        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                    }
                    this.builder().close(destroyProcess2);
                    throw throwable;
                }
                if (acquiredPermit) {
                    $this.startupProcessSemaphore.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                        x$7.release();
                        return BoxedUnit.UNIT;
                    });
                }
                boolean bl = destroyProcess = !this.builder().waitEngineCompletion();
                if (destroyProcess) {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                }
                this.builder().close(destroyProcess);
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)discoveryClient.getServerHost(this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(discoveryClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Object, String> deregister(DiscoveryClient discoveryClient, Tuple2<String, Object> hostPort) {
        return (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
            Seq seq = discoveryClient.getServiceNodesInfo(this.engineSpace(), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
                Tuple2 tuple2 = new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port()));
                Tuple2 tuple22 = hostPort;
                if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                    String msg = new StringBuilder(21).append("Deleting engine node:").append(sn).toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> msg);
                    discoveryClient.delete(new StringBuilder(1).append(this.engineSpace()).append("/").append(sn.nodeName()).toString(), discoveryClient.delete$default$2());
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
                }
                String msg = new StringBuilder(44).append("Engine node:").append(sn).append(" is not matched with host&port[").append(hostPort).append("]").toString();
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> msg);
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)msg);
            }
            String msg = new StringBuilder(24).append("No engine node found in ").append(this.engineSpace()).toString();
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> msg);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)msg);
        });
    }

    public Option<ServiceNodeInfo> getServiceNode(DiscoveryClient discoveryClient, Tuple2<String, Object> hostPort) {
        Seq serviceNodes = discoveryClient.getServiceNodesInfo(this.engineSpace(), discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3());
        return serviceNodes.find((Function1 & Serializable & scala.Serializable)sn -> BoxesRunTime.boxToBoolean((boolean)EngineRef.$anonfun$getServiceNode$1(hostPort, sn)));
    }

    public void close() {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        if (!(value != null ? !value.equals(value2) : value2 != null) && this.builder() != null) {
            try {
                ApplicationManagerInfo appMgrInfo = this.builder().appMgrInfo();
                this.builder().close(true);
                this.engineManager.killApplication(appMgrInfo, this.engineRefId, (Option<String>)new Some((Object)this.appUser()));
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error closing engine builder, engineRefId: ").append($this.engineRefId).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$create$7(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public static final /* synthetic */ void $anonfun$create$11(EngineRef $this, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{"ENGINE_TERMINATE"}));
    }

    public static final /* synthetic */ void $anonfun$create$10(EngineRef $this, ApplicationInfo appInfo) {
        if (ApplicationState$.MODULE$.isTerminated(appInfo.state())) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                EngineRef.$anonfun$create$11($this, ms);
                return BoxedUnit.UNIT;
            });
            throw new KyuubiSQLException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n                     |The engine application has been terminated. Please check the engine log.\n                     |ApplicationInfo: ").append(appInfo.toMap().mkString("(\n", ",\n", "\n)")).append("\n                     |").toString())).stripMargin(), $this.builder().getError());
        }
    }

    public static final /* synthetic */ void $anonfun$create$9(EngineRef $this, ObjectRef lastApplicationInfo$1, long started$1, KyuubiApplicationManager engineMgr) {
        if (((Option)lastApplicationInfo$1.elem).isDefined()) {
            TimeUnit.SECONDS.sleep(1L);
        }
        Option<ApplicationInfo> applicationInfo = engineMgr.getApplicationInfo($this.builder().appMgrInfo(), $this.engineRefId, (Option<String>)new Some((Object)$this.appUser()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)started$1)));
        applicationInfo.foreach((Function1 & Serializable & scala.Serializable)appInfo -> {
            EngineRef.$anonfun$create$10($this, appInfo);
            return BoxedUnit.UNIT;
        });
        lastApplicationInfo$1.elem = applicationInfo;
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNode$1(Tuple2 hostPort$2, ServiceNodeInfo sn) {
        Tuple2 tuple2 = new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port()));
        Tuple2 tuple22 = hostPort$2;
        return !(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null);
    }

    public EngineRef(KyuubiConf conf, String sessionUser, boolean doAsEnabled, GroupProvider groupProvider, String engineRefId, KyuubiApplicationManager engineManager, Option<Semaphore> startupProcessSemaphore) {
        String string;
        String string2;
        String string3;
        boolean bl;
        this.conf = conf;
        this.doAsEnabled = doAsEnabled;
        this.engineRefId = engineRefId;
        this.engineManager = engineManager;
        this.startupProcessSemaphore = startupProcessSemaphore;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)((KyuubiConf)Option$.MODULE$.apply((Object)engineManager).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getConf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()))).get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        this.clientPoolName = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_NAME());
        this.enginePoolIgnoreSubdomain = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_IGNORE_SUBDOMAIN()));
        this.enginePoolSelectPolicy = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SELECT_POLICY());
        this.LOCK_TIMEOUT_SPAN_FACTOR = Utils$.MODULE$.isTesting() ? 0.5 : 0.1;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.SERVER_LOCAL();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            string3 = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value6 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value7 = value;
            string3 = !(value6 != null ? !value6.equals(value7) : value7 != null) ? groupProvider.primaryGroup(sessionUser, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf.getAll()).asJava()) : sessionUser;
        }
        this.routingUser = string3;
        this.appUser = doAsEnabled ? this.routingUser() : Utils$.MODULE$.currentUser();
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (this.clientPoolSize() > 0 && (option.isEmpty() || this.enginePoolIgnoreSubdomain())) {
            int n;
            String string4;
            int poolSize = scala.math.package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            if ("POLLING".equals(string4 = this.enginePoolSelectPolicy())) {
                String snPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(10).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_seqNum").toString(), this.routingUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.clientPoolName()}));
                n = BoxesRunTime.unboxToInt((Object)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(conf, (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToInteger((int)client.getAndIncrement(snPath, client.getAndIncrement$default$2()))));
            } else if ("RANDOM".equals(string4)) {
                n = Random$.MODULE$.nextInt(poolSize);
            } else {
                throw new MatchError((Object)string4);
            }
            int seqNum = n;
            string2 = new StringBuilder(1).append(this.clientPoolName()).append("-").append(seqNum % poolSize).toString();
        } else if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string2 = _subdomain = (String)some.value();
        } else {
            string2 = "default";
        }
        this.subdomain = string2;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.routingUser()).toString();
        Enumeration.Value value8 = this.shareLevel();
        Enumeration.Value value9 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value10 = value8;
        if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
            string = new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString();
        } else {
            Enumeration.Value value11 = ShareLevel$.MODULE$.SERVER_LOCAL();
            Enumeration.Value value12 = value8;
            string = !(value11 != null ? !value11.equals(value12) : value12 != null) ? new StringBuilder(3).append(commonNamePrefix).append("_").append(this.localHostAddr()).append("_").append(this.subdomain()).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
        }
        this.defaultEngineName = string;
    }
}

