<!--
RULES
* Never place a link to an external site like Google Doc. The proposal should be in this issue entirely.
* Use a spelling and grammar checker tools if available for you (there are plenty of free ones).

PROPOSAL HEALTH CHECK
I can read the design document and understand the problem statement and what you plan to change *without* resorting to a couple of hours of code reading just to start having a high level understanding of the change.

IMAGES
If you need diagrams, avoid attaching large files. You can use [MermaidJS]([url](https://mermaid.js.org/)) as a simple language to describe many types of diagrams.

THIS COMMENTS
Please remove them when done.
-->

# PIP-329: Strategy for maintaining the latest tag to Pulsar docker images

# Motivation

There is a gap in our current release process concerning the
pushing of the latest tag to our Docker images. Specifically, we need
to decide which version of Pulsar the latest tag should point to.

We've had initial agreement from previous discussions, found
here: https://lists.apache.org/thread/h4m90ff7dgx0110onctf5ntq0ktydzv1.

Now, we need to formally propose a PIP to address this.

# Goals

## In Scope

- Define the strategy for maintaining the latest tag to Pulsar docker images in the release process

## Out of Scope

- None

# High Level Design

Refine the release process to clearly demonstrate the strategy for managing the 'latest' tag for Pulsar Docker images:

The 'latest' tag should be pointed to the most recent feature release or any subsequent patch of that feature
release. For instance, if the most recent feature release is version 3.1, and it has been updated with patches, the '
latest' tag could point to version 3.1.2, assuming this is the latest patch for the 3.1 feature. Alternatively, if a new
feature release, say 3.2.0, is introduced, the 'latest' tag would then point to this new version.

In simpler terms, the `latest` tag will always point to the newest version of a feature.

# Alternatives

An alternative strategy is

> The latest tag could point to the most recent feature release or
> the subsequent patch of that feature release. For instance, it could
> currently point to 3.1.1, and in the future, it could point to 3.1.2
> or 3.2.0.

Feedback from the community indicates a preference for the solution proposed by this PIP.

# General Notes

- Discussion
  of `Strategy for pushing the latest tag to Pulsar docker images`: https://lists.apache.org/thread/h4m90ff7dgx0110onctf5ntq0ktydzv1
- The implementation PR for this PIP: https://github.com/apache/pulsar-site/pull/745

# Links

* Mailing List discussion thread: https://lists.apache.org/thread/x7r1f2vgmowykwdcb3mmrv0d8lj4y1t9
* Mailing List voting thread: https://lists.apache.org/thread/f9j0xjjlyz54880zyzon3xm5y0zn37xb
