/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.crc;

import com.scurrilous.circe.crc.AbstractIntCrc;

final class ReflectedIntCrc
extends AbstractIntCrc {
    private final int[] table = new int[256];

    ReflectedIntCrc(String algorithm, int width, int poly, int init, int xorOut) {
        super(algorithm, width, init, xorOut);
        poly = this.reflect(poly);
        for (int i = 0; i < 256; ++i) {
            int crc = i;
            for (int j = 0; j < 8; ++j) {
                crc = (crc & 1) != 0 ? crc >>> 1 ^ poly : crc >>> 1;
            }
            this.table[i] = crc;
        }
    }

    @Override
    protected int initial() {
        return this.reflect(super.initial());
    }

    @Override
    protected int resumeRaw(int crc, byte[] input, int index, int length) {
        for (int i = 0; i < length; ++i) {
            crc = this.table[(crc ^ input[index + i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }
}

