/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class DropDeParser
extends AbstractDeParser<Drop> {
    public DropDeParser(StringBuilder buffer) {
        super(buffer);
    }

    @Override
    public void deParse(Drop drop) {
        this.buffer.append("DROP ");
        this.buffer.append(drop.getType());
        if (drop.isIfExists()) {
            this.buffer.append(" IF EXISTS");
        }
        this.buffer.append(" ").append(drop.getName());
        if (drop.getType().equals("FUNCTION")) {
            this.buffer.append(Drop.formatFuncParams(drop.getParamsByType("FUNCTION")));
        }
        if (drop.getParameters() != null && !drop.getParameters().isEmpty()) {
            this.buffer.append(" ").append(PlainSelect.getStringList(drop.getParameters()));
        }
    }
}

