/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.locksupport;

import com.hazelcast.internal.locksupport.LockDataSerializerHook;
import com.hazelcast.internal.locksupport.LockResource;
import com.hazelcast.internal.locksupport.LockStoreImpl;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

final class LockResourceImpl
implements IdentifiedDataSerializable,
LockResource {
    private Data key;
    private UUID owner;
    private long threadId;
    private long referenceId;
    private int lockCount;
    private long expirationTime = -1L;
    private long acquireTime = -1L;
    private boolean transactional;
    private boolean blockReads;
    private boolean local;
    private LockStoreImpl lockStore;
    private transient int version;

    LockResourceImpl() {
    }

    LockResourceImpl(Data key, LockStoreImpl lockStore) {
        this.key = key;
        this.lockStore = lockStore;
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public boolean isLocked() {
        return this.lockCount > 0;
    }

    @Override
    public boolean isLockedBy(UUID owner, long threadId) {
        return this.threadId == threadId && owner != null && owner.equals(this.owner);
    }

    boolean lock(UUID owner, long threadId, long referenceId, long leaseTime, boolean transactional, boolean blockReads, boolean local) {
        if (this.lockCount == 0) {
            this.owner = owner;
            this.threadId = threadId;
            this.referenceId = referenceId;
            this.lockCount = 1;
            this.acquireTime = Clock.currentTimeMillis();
            this.setExpirationTime(leaseTime);
            this.transactional = transactional;
            this.blockReads = blockReads;
            this.local = local;
            return true;
        }
        if (this.isLockedBy(owner, threadId)) {
            if (!transactional && !local && this.referenceId == referenceId) {
                return true;
            }
            this.referenceId = referenceId;
            ++this.lockCount;
            this.setExpirationTime(leaseTime);
            this.transactional = transactional;
            this.blockReads = blockReads;
            this.local = local;
            return true;
        }
        return false;
    }

    boolean extendLeaseTime(UUID caller, long threadId, long leaseTime) {
        if (!this.isLockedBy(caller, threadId)) {
            return false;
        }
        this.blockReads = true;
        if (this.expirationTime < Long.MAX_VALUE) {
            this.setExpirationTime(this.expirationTime - Clock.currentTimeMillis() + leaseTime);
        }
        return true;
    }

    private void setExpirationTime(long leaseTime) {
        ++this.version;
        if (leaseTime < 0L) {
            this.expirationTime = Long.MAX_VALUE;
            this.lockStore.cancelEviction(this.key);
        } else {
            this.expirationTime = Clock.currentTimeMillis() + leaseTime;
            if (this.expirationTime < 0L) {
                this.expirationTime = Long.MAX_VALUE;
                this.lockStore.cancelEviction(this.key);
            } else {
                this.lockStore.scheduleEviction(this.key, this.version, leaseTime);
            }
        }
    }

    boolean unlock(UUID owner, long threadId, long referenceId) {
        if (this.lockCount == 0) {
            return false;
        }
        if (!this.isLockedBy(owner, threadId)) {
            return false;
        }
        if (!this.transactional && !this.local && this.referenceId == referenceId) {
            return true;
        }
        this.referenceId = referenceId;
        --this.lockCount;
        if (this.lockCount == 0) {
            this.clear();
        }
        return true;
    }

    boolean canAcquireLock(UUID caller, long threadId) {
        return this.lockCount == 0 || this.getThreadId() == threadId && this.getOwner().equals(caller);
    }

    void clear() {
        this.threadId = 0L;
        this.lockCount = 0;
        this.owner = null;
        this.referenceId = 0L;
        this.expirationTime = 0L;
        this.acquireTime = -1L;
        this.cancelEviction();
        this.version = 0;
        this.transactional = false;
        this.blockReads = false;
        this.local = false;
    }

    void cancelEviction() {
        this.lockStore.cancelEviction(this.key);
    }

    boolean isRemovable() {
        return !this.isLocked();
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public boolean isTransactional() {
        return this.transactional;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public boolean shouldBlockReads() {
        return this.blockReads;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public int getLockCount() {
        return this.lockCount;
    }

    @Override
    public long getAcquireTime() {
        return this.acquireTime;
    }

    @Override
    public long getRemainingLeaseTime() {
        if (!this.isLocked()) {
            return -1L;
        }
        if (this.expirationTime < 0L) {
            return Long.MAX_VALUE;
        }
        long now = Clock.currentTimeMillis();
        if (now >= this.expirationTime) {
            return 0L;
        }
        return this.expirationTime - now;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    void setLockStore(LockStoreImpl lockStore) {
        this.lockStore = lockStore;
    }

    @Override
    public int getFactoryId() {
        return LockDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        IOUtil.writeData(out, this.key);
        UUIDSerializationUtil.writeUUID(out, this.owner);
        out.writeLong(this.threadId);
        out.writeLong(this.referenceId);
        out.writeInt(this.lockCount);
        out.writeLong(this.expirationTime);
        out.writeLong(this.acquireTime);
        out.writeBoolean(this.transactional);
        out.writeBoolean(this.blockReads);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = IOUtil.readData(in);
        this.owner = UUIDSerializationUtil.readUUID(in);
        this.threadId = in.readLong();
        this.referenceId = in.readLong();
        this.lockCount = in.readInt();
        this.expirationTime = in.readLong();
        this.acquireTime = in.readLong();
        this.transactional = in.readBoolean();
        this.blockReads = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockResourceImpl that = (LockResourceImpl)o;
        if (this.threadId != that.threadId) {
            return false;
        }
        return Objects.equals(this.owner, that.owner);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + (int)(this.threadId ^ this.threadId >>> 32);
        return result;
    }

    public String toString() {
        return "LockResource{owner='" + this.owner + '\'' + ", threadId=" + this.threadId + ", lockCount=" + this.lockCount + ", acquireTime=" + this.acquireTime + ", expirationTime=" + this.expirationTime + '}';
    }
}

