Contributing to AliceVision
===========================

Alice Vision relies on a friendly and community-driven effort to create an open source photogrammetry solution.
In order to foster a friendly atmosphere where technical collaboration can flourish,
we recommend you to read the [code of conduct](CODE_OF_CONDUCT.md).


Contributing Workflow
---------------------

The contributing workflow relies on [Github Pull Requests](https://help.github.com/articles/using-pull-requests/).

1. If it is an important change, we recommend you to discuss it on the mailing-list
before starting implementation. This ensure that the development is aligned with other developments already started and will be efficiently integrated.

2. Create the corresponding issues.

3. Create a branch and start a PR starting by [WIP], like "[WIP] My new feature" so everyone can follow the development.
Explain the implementation in the PR description with links to issues.

4. Implement the new feature(s). Add unit test if needed.
One feature per PR is ideal for review, but linked features can be part of the same PR.

5. When it is ready for review, remove "WIP" from the PR name.

6. The reviewers will look over the code and ask for changes, explain problems they found,
congratulate the author, etc. using the github comments.

7. After approval, one of the developers with commit approval to the official main repository
will merge your fixes into the "develop" branch.

8. If not already the case, your name will be added to the [contributors list](CONTRIBUTORS.md).

