# Arcade - a Roadmap

Please read the [Arcade overview document](https://github.com/dotnet/arcade/blob/master/Documentation/Overview.md) for principles and requirements - as well as an overview.

How to read this Roadmap:
- Each bullet in the phases link to the driving epic.
- Epics contain a) what "done" means, and b) all the issues associated with the work.  (Note: We use [ZenHub](https://www.zenhub.com/) to make sense of epics)
- For the most part, each epic in the phases can be done in parallel.  This means that the order of the bullets in the phases don't necessarily imply priority.
- Timing information (when available) is in each epic
- This roadmap is a living document.  Full history (and most discussions) are in the issues/PRs themselves


## Phase I
Arcade exists and is useful for building and publishing shared packages.

- [x] [Arcade building and publishing packages in the open](https://github.com/dotnet/arcade/issues/45)
- [ ] ["Maestro" for Arcade scripts ](https://github.com/dotnet/arcade/issues/74)
- [ ] [Arcade is serviceable](https://github.com/dotnet/arcade/issues/75)

## Phase II 
Arcade builds itself and is largely converged with the other toolsets

- [ ] [Arcade is building Arcade](https://github.com/dotnet/arcade/issues/72)
- [ ] [Bootstrap for native builds](https://github.com/dotnet/arcade/issues/73)
- [ ] [Use arcade as a "canary" build](https://github.com/dotnet/arcade/issues/111)
- [ ] [Define and Implement Repo API](https://github.com/dotnet/arcade/issues/85)
- [ ] [Converge "kore-build" and Arcade](https://github.com/dotnet/arcade/issues/88)
- [ ] [Converge "repotoolset" and Arcade](https://github.com/dotnet/arcade/issues/89)
- [ ] [Converge "buildtools" and Arcade](https://github.com/dotnet/arcade/issues/90)

## Phase III
Arcade is usable as a baseline for all repos in the stack.  The last bit of "impedance matching" work goes into this phase.  No epics yet, as phase III will clarify itself during Phase II.







<!-- Begin Generated Content: Doc Feedback -->
<sub>Was this helpful? [![Yes](https://helix.dot.net/f/ip/5?p=Documentation%5CRoadmap.md)](https://helix.dot.net/f/p/5?p=Documentation%5CRoadmap.md) [![No](https://helix.dot.net/f/in)](https://helix.dot.net/f/n/5?p=Documentation%5CRoadmap.md)</sub>
<!-- End Generated Content-->
