# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Optional, TypeVar, Union

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer
from .._vendor import MicrosoftSerialConsoleClientMixinABC, _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_operations_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2018-05-01"))  # type: Literal["2018-05-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/providers/Microsoft.SerialConsole/operations")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_console_status_request(default: str, subscription_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2018-05-01"))  # type: Literal["2018-05-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.SerialConsole/consoleServices/{default}"
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "default": _SERIALIZER.url("default", default, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_disable_console_request(default: str, subscription_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2018-05-01"))  # type: Literal["2018-05-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.SerialConsole/consoleServices/{default}/disableConsole",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "default": _SERIALIZER.url("default", default, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_enable_console_request(default: str, subscription_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2018-05-01"))  # type: Literal["2018-05-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.SerialConsole/consoleServices/{default}/enableConsole",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "default": _SERIALIZER.url("default", default, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class MicrosoftSerialConsoleClientOperationsMixin(MicrosoftSerialConsoleClientMixinABC):
    @distributed_trace
    def list_operations(self, **kwargs: Any) -> _models.SerialConsoleOperations:
        """Gets a list of Serial Console API operations.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SerialConsoleOperations or the result of cls(response)
        :rtype: ~azure.mgmt.serialconsole.models.SerialConsoleOperations
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2018-05-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.SerialConsoleOperations]

        request = build_list_operations_request(
            api_version=api_version,
            template_url=self.list_operations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SerialConsoleOperations", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_operations.metadata = {"url": "/providers/Microsoft.SerialConsole/operations"}  # type: ignore

    @distributed_trace
    def get_console_status(
        self, default: str, **kwargs: Any
    ) -> Union[_models.SerialConsoleStatus, _models.GetSerialConsoleSubscriptionNotFound]:
        """Get the disabled status for a subscription.

        Gets whether or not Serial Console is disabled for a given subscription.

        :param default: Default parameter. Leave the value as "default". Required.
        :type default: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SerialConsoleStatus or GetSerialConsoleSubscriptionNotFound or the result of
         cls(response)
        :rtype: ~azure.mgmt.serialconsole.models.SerialConsoleStatus or
         ~azure.mgmt.serialconsole.models.GetSerialConsoleSubscriptionNotFound
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2018-05-01"]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.SerialConsoleStatus, _models.GetSerialConsoleSubscriptionNotFound]]

        request = build_get_console_status_request(
            default=default,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_console_status.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("SerialConsoleStatus", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("GetSerialConsoleSubscriptionNotFound", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_console_status.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.SerialConsole/consoleServices/{default}"}  # type: ignore

    @distributed_trace
    def disable_console(
        self, default: str, **kwargs: Any
    ) -> Union[_models.DisableSerialConsoleResult, _models.GetSerialConsoleSubscriptionNotFound]:
        """Disable Serial Console for a subscription.

        Disables the Serial Console service for all VMs and VM scale sets in the provided subscription.

        :param default: Default parameter. Leave the value as "default". Required.
        :type default: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DisableSerialConsoleResult or GetSerialConsoleSubscriptionNotFound or the result of
         cls(response)
        :rtype: ~azure.mgmt.serialconsole.models.DisableSerialConsoleResult or
         ~azure.mgmt.serialconsole.models.GetSerialConsoleSubscriptionNotFound
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2018-05-01"]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.DisableSerialConsoleResult, _models.GetSerialConsoleSubscriptionNotFound]]

        request = build_disable_console_request(
            default=default,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.disable_console.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("DisableSerialConsoleResult", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("GetSerialConsoleSubscriptionNotFound", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    disable_console.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.SerialConsole/consoleServices/{default}/disableConsole"}  # type: ignore

    @distributed_trace
    def enable_console(
        self, default: str, **kwargs: Any
    ) -> Union[_models.EnableSerialConsoleResult, _models.GetSerialConsoleSubscriptionNotFound]:
        """Enable Serial Console for a subscription.

        Enables the Serial Console service for all VMs and VM scale sets in the provided subscription.

        :param default: Default parameter. Leave the value as "default". Required.
        :type default: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EnableSerialConsoleResult or GetSerialConsoleSubscriptionNotFound or the result of
         cls(response)
        :rtype: ~azure.mgmt.serialconsole.models.EnableSerialConsoleResult or
         ~azure.mgmt.serialconsole.models.GetSerialConsoleSubscriptionNotFound
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2018-05-01"]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.EnableSerialConsoleResult, _models.GetSerialConsoleSubscriptionNotFound]]

        request = build_enable_console_request(
            default=default,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.enable_console.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("EnableSerialConsoleResult", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("GetSerialConsoleSubscriptionNotFound", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    enable_console.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.SerialConsole/consoleServices/{default}/enableConsole"}  # type: ignore
